/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.rpc.modulebootstrap;

import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.message.Response;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.NC)
public class ModuleStatusCmd
extends BaseCmd {
    @Autowired
    RpcModule rpcModule;

    @CmdAnnotation(scope="private", cmd="listenerDependenciesReady", version=1.0, minEvent=1, description="notify module is ready")
    public Response listenerDependenciesReady(Map<String, Object> map) {
        Log.info((String)"listenerDependenciesReady : {}", (Object[])new Object[]{map});
        Module module = (Module)JSONUtils.map2pojo(map, Module.class);
        this.rpcModule.listenerDependenciesReady(module);
        return this.success("ModuleReadyListener success " + this.rpcModule.moduleInfo());
    }

    @CmdAnnotation(scope="private", cmd="registerModuleDependencies", version=1.0, minEvent=1, description="Register module followerList")
    public Response followModule(Map<String, Object> param) {
        Log.info((String)"registerModuleDependencies : {}", (Object[])new Object[]{param});
        Module module = (Module)JSONUtils.map2pojo(param, Module.class);
        this.rpcModule.addFollower(module);
        return this.success("ModuleDependenciesRegisterListener success " + this.rpcModule.moduleInfo());
    }

    @CmdAnnotation(scope="private", cmd="connectReady", version=1.0, minEvent=1, description="check module rpc is ready")
    public Response connectReady(Map<String, Object> param) {
        return this.success(this.rpcModule.isReady());
    }
}

