/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.config;

import io.nuls.core.core.annotation.Value;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ConfigSetting {
    static Map<Class, Function<String, Object>> transfer = new HashMap<Class, Function<String, Object>>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(Object obj, Field field, String value) {
        if (null == value) {
            Value.NotNull notNull = field.getAnnotation(Value.NotNull.class);
            if (notNull == null) return;
            throw new RuntimeException("config item " + obj.getClass() + "#" + field.getName() + " can't be null ");
        }
        field.setAccessible(true);
        if (ConfigSetting.isPrimitive(field)) {
            try {
                field.set(obj, transfer.get(field.getType()).apply(value));
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException("inject config item error : " + obj.getClass() + "#" + field.getName(), e2);
            }
        }
        try {
            if (Collection.class.isAssignableFrom(field.getType())) {
                if (!List.class.isAssignableFrom(field.getType())) throw new RuntimeException("Collection type only support List ");
                if (field.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)field.getGenericType();
                    field.set(obj, JSONUtils.json2list(value, Class.forName(pt.getActualTypeArguments()[0].getTypeName())));
                }
            } else if (field.getType().isEnum()) {
                Arrays.stream(field.getType().getEnumConstants()).forEach(e -> {
                    if (String.valueOf(e).equals(value)) {
                        try {
                            field.set(obj, e);
                        }
                        catch (IllegalAccessException e1) {
                            throw new RuntimeException("inject config item error : " + obj.getClass() + "#" + field.getName(), e1);
                        }
                    }
                });
            } else {
                field.set(obj, JSONUtils.json2pojo(value, field.getType()));
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException e3) {
            throw new RuntimeException("inject config item error : " + obj.getClass() + "#" + field.getName(), e3);
        }
        field.setAccessible(false);
    }

    public static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls.equals(String.class) || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Short.class) || cls.equals(Float.class) || cls.equals(Double.class) || cls.equals(Character.class) || cls.equals(Byte.class) || cls.equals(Boolean.class);
    }

    private static boolean isPrimitive(Field field) {
        return ConfigSetting.isPrimitive(field.getType());
    }

    static {
        transfer.put(Integer.class, Integer::parseInt);
        transfer.put(Integer.TYPE, Integer::parseInt);
        transfer.put(Long.class, Long::parseLong);
        transfer.put(Long.TYPE, Long::parseLong);
        transfer.put(Float.class, Float::parseFloat);
        transfer.put(Float.TYPE, Float::parseFloat);
        transfer.put(Double.class, Double::parseDouble);
        transfer.put(Double.TYPE, Double::parseDouble);
        transfer.put(Character.class, str -> Character.valueOf(str.charAt(0)));
        transfer.put(Character.TYPE, str -> Character.valueOf(str.charAt(0)));
        transfer.put(Short.class, Short::parseShort);
        transfer.put(Short.TYPE, Short::parseShort);
        transfer.put(Boolean.class, Boolean::parseBoolean);
        transfer.put(Boolean.TYPE, Boolean::parseBoolean);
        transfer.put(Byte.class, Byte::parseByte);
        transfer.put(Byte.TYPE, Byte::parseByte);
        transfer.put(String.class, str -> str);
    }
}

