/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.core.config.persist;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.core.core.annotation.Configuration;
import io.nuls.core.core.annotation.Persist;
import io.nuls.core.core.annotation.Value;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PersistManager {
    static final String CONFIG_FOLDER = "config_tmp";

    public static synchronized void saveConfigItem(Configuration annotation, Object object, Method method, Object[] params) {
        Map<String, String> configValue;
        if (params.length == 0) {
            return;
        }
        Log.info("save config item to disk");
        Object filedName = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
        try {
            Field field = object.getClass().getSuperclass().getDeclaredField((String)filedName);
            Persist persist = field.getAnnotation(Persist.class);
            if (persist == null) {
                return;
            }
            Value value = field.getAnnotation(Value.class);
            if (value != null) {
                filedName = value.value();
            }
        }
        catch (NoSuchFieldException e) {
            Log.warn("not found field :{} in {}", filedName, object.getClass());
            return;
        }
        File configDir = new File(CONFIG_FOLDER);
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!configDir.isDirectory()) {
            Log.warn("config is not folder, abort save config item");
            return;
        }
        String configFileName = annotation.domain();
        File configFile = new File(CONFIG_FOLDER + File.separator + configFileName);
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                Log.warn("create config file fail.");
                return;
            }
            configValue = new HashMap<String, String>();
        } else {
            configValue = PersistManager.readConfigFileToMap(configFile);
        }
        configValue.put((String)filedName, String.valueOf(params[0]));
        String configValueJson = null;
        try {
            configValueJson = JSONUtils.getInstance().writerWithDefaultPrettyPrinter().writeValueAsString(configValue);
        }
        catch (JsonProcessingException e) {
            Log.warn("format config value fail.", e);
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(configFile)));){
            writer.write(configValueJson);
        }
        catch (IOException e) {
            Log.error("save config item fail", e);
        }
    }

    public static Map<String, Map<String, String>> loadPersist() {
        File configDir = new File(CONFIG_FOLDER);
        HashMap<String, Map<String, String>> res = new HashMap<String, Map<String, String>>();
        if (!configDir.exists() || !configDir.isDirectory()) {
            return new HashMap<String, Map<String, String>>();
        }
        Arrays.stream(configDir.listFiles()).forEach(configFile -> {
            Map<String, String> config = PersistManager.readConfigFileToMap(configFile);
            res.put(configFile.getName(), config);
        });
        return res;
    }

    private static Map<String, String> readConfigFileToMap(File configFile) {
        Map<String, String> map;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
        try {
            String line;
            StringBuilder temp = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                temp.append(line);
            }
            map = JSONUtils.jsonToMap(temp.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Log.error("read config item fail", e);
                return new HashMap<String, String>();
            }
        }
        reader.close();
        return map;
    }
}

