/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import io.nuls.core.model.StringUtils;
import java.math.BigInteger;

public class BigIntegerUtils {
    public static final String ZERO = String.valueOf(0);

    public static BigInteger stringToBigInteger(String str) {
        BigInteger bigInteger = new BigInteger("0");
        if (!StringUtils.isBlank(str)) {
            bigInteger = new BigInteger(str);
        }
        return bigInteger;
    }

    public static String bigIntegerToString(BigInteger bigInteger) {
        return String.valueOf(bigInteger);
    }

    public static String bigIntegerToString(BigInteger bigInteger, int size) {
        String value;
        int length;
        String symbol = "";
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            symbol = "-";
            bigInteger = bigInteger.abs();
        }
        if ((length = size - (value = bigInteger.toString()).length()) > 0) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                buffer.append(0);
            }
            value = buffer.append(value).toString();
        }
        return symbol + value;
    }

    public static String addToString(String str1, String str2) {
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).add(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger addToBigInteger(String str1, String str2) {
        return BigIntegerUtils.stringToBigInteger(str1).add(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static String subToString(String str1, String str2) {
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).subtract(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger subToBigInteger(String str1, String str2) {
        return BigIntegerUtils.stringToBigInteger(str1).subtract(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static String mulToString(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return "0";
        }
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).multiply(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger mulToInteger(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return new BigInteger("0");
        }
        return BigIntegerUtils.stringToBigInteger(str1).multiply(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static String divToString(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return "0";
        }
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).divide(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger divToBigInteger(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return new BigInteger("0");
        }
        return BigIntegerUtils.stringToBigInteger(str1).divide(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static String modToString(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return "0";
        }
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).mod(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger modToBigIntegr(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return new BigInteger("0");
        }
        return BigIntegerUtils.stringToBigInteger(str1).mod(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static String remToString(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return "0";
        }
        return BigIntegerUtils.bigIntegerToString(BigIntegerUtils.stringToBigInteger(str1).remainder(BigIntegerUtils.stringToBigInteger(str2)));
    }

    public static BigInteger remToBigInteger(String str1, String str2) {
        if (StringUtils.isBlank(str1) || StringUtils.isBlank(str2)) {
            return new BigInteger("0");
        }
        return BigIntegerUtils.stringToBigInteger(str1).remainder(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static int compare(String str1, String str2) {
        return BigIntegerUtils.stringToBigInteger(str1).compareTo(BigIntegerUtils.stringToBigInteger(str2));
    }

    public static boolean isEqual(String str1, String str2) {
        return BigIntegerUtils.compare(str1, str2) == 0;
    }

    public static boolean isEqual(BigInteger b1, BigInteger b2) {
        return b1.compareTo(b2) == 0;
    }

    public static boolean isLessThan(String str1, String str2) {
        return BigIntegerUtils.compare(str1, str2) < 0;
    }

    public static boolean isLessThan(BigInteger b1, BigInteger b2) {
        return b1.compareTo(b2) < 0;
    }

    public static boolean isGreaterThan(String str1, String str2) {
        return BigIntegerUtils.compare(str1, str2) > 0;
    }

    public static boolean isGreaterThan(BigInteger b1, BigInteger b2) {
        return b1.compareTo(b2) > 0;
    }

    public static boolean isEqualOrGreaterThan(BigInteger b1, BigInteger b2) {
        return b1.compareTo(b2) >= 0;
    }

    public static boolean isEqualOrLessThan(BigInteger b1, BigInteger b2) {
        return b1.compareTo(b2) <= 0;
    }
}

