/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class DateUtils {
    public static final String EMPTY_SRING = "";
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss.sss";
    public static final long DATE_TIME = 86400000L;
    public static final long HOUR_TIME = 3600000L;
    public static final long MINUTE_TIME = 60000L;
    public static final long SECOND_TIME = 1000L;
    public static final long TIME_ZONE;
    public static final String TIME_ZONE_STRING;
    public static final long TEN_MINUTE_TIME = 600000L;
    private static final ThreadLocal<DateFormat> DATE_FORMATTER_17;
    private static final ThreadLocal<DateFormat> DATE_FORMATTER_14;

    public static long minutesToMillis(long minutes) {
        return minutes * 60L * 1000L;
    }

    public static long secondsToMillis(long seconds) {
        return seconds * 1000L;
    }

    public static long millisToMinutes(long millis) {
        return Math.round((double)millis / 60.0 / 1000.0);
    }

    public static long millisToSeconds(long millis) {
        return Math.round((double)millis / 1000.0);
    }

    public static long timeAfterMillis(long millis) {
        return System.currentTimeMillis() + millis;
    }

    public static String toGMTString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.UK);
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }

    public static String convertDate(Date date) {
        if (date == null) {
            return EMPTY_SRING;
        }
        return DATE_FORMATTER_14.get().format(date);
    }

    public static String convertDate(Date date, String pattern) {
        if (date == null) {
            return EMPTY_SRING;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date convertStringToDate(String date) {
        try {
            return DATE_FORMATTER_14.get().parse(date);
        }
        catch (ParseException parseException) {
            return new Date();
        }
    }

    public static Date convertStringToDate(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isFirstDayInMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5) == 1;
    }

    public static boolean isFirstDayInYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6) == 1;
    }

    public static Date rounding(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date dateAdd(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + day);
        return calendar.getTime();
    }

    public static Date dateAddMonth(Date date, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) + month);
        return calendar.getTime();
    }

    public static Date getFirstDayOfPreviousMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - 1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth() {
        return DateUtils.getFirstDayOfMonth(new Date());
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayOfPreviousYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, calendar.get(1) - 1);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static List<String> getDateRange(String beginDate, String endDate, int type) {
        ArrayList<String> list;
        block6: {
            block5: {
                list = new ArrayList<String>();
                if (DateUtils.isEmpty(beginDate) || DateUtils.isEmpty(endDate)) {
                    return list;
                }
                if (type != 1) break block5;
                Date begin = DateUtils.convertStringToDate(beginDate, "yyyy-MM-dd");
                Date end = DateUtils.convertStringToDate(endDate, "yyyy-MM-dd");
                if (begin == null || end == null) {
                    return list;
                }
                while (begin.equals(end) || begin.before(end)) {
                    list.add(DateUtils.convertDate(begin, "MM-dd"));
                    begin = DateUtils.dateAdd(begin, 1);
                }
                break block6;
            }
            if (type != 2) break block6;
            Date begin = DateUtils.convertStringToDate(beginDate, "yyyy-MM-dd");
            Date end = DateUtils.convertStringToDate(endDate, "yyyy-MM-dd");
            if (begin == null || end == null) {
                return list;
            }
            Calendar beginCalendar = Calendar.getInstance();
            beginCalendar.setTime(begin);
            beginCalendar.set(5, 1);
            Calendar endCalendar = Calendar.getInstance();
            endCalendar.setTime(end);
            endCalendar.set(5, 1);
            while (beginCalendar.getTime().equals(endCalendar.getTime()) || beginCalendar.getTime().before(endCalendar.getTime())) {
                list.add(DateUtils.convertDate(beginCalendar.getTime(), "yyyy-MM"));
                beginCalendar.set(2, beginCalendar.get(2) + 1);
            }
        }
        return list;
    }

    public static boolean isEmpty(Object obj) {
        return obj == null || EMPTY_SRING.equals(obj);
    }

    public static String getWeekDay(Calendar c) {
        if (c == null) {
            return "Monday";
        }
        if (2 == c.get(7)) {
            return "Monday";
        }
        if (3 == c.get(7)) {
            return "Tuesday";
        }
        if (4 == c.get(7)) {
            return "Wednesday";
        }
        if (5 == c.get(7)) {
            return "Thursday";
        }
        if (6 == c.get(7)) {
            return "Friday";
        }
        if (7 == c.get(7)) {
            return "Saturday";
        }
        if (1 == c.get(7)) {
            return "Sunday";
        }
        return "Monday";
    }

    public static String convertLebalFull(Date startTime, Date endTime, boolean showSuffix) {
        if (startTime == null || endTime == null) {
            return EMPTY_SRING;
        }
        long time = (startTime.getTime() - endTime.getTime()) / 1000L;
        Object label = DateUtils.analyzeTime(time, true);
        if (showSuffix) {
            label = (String)label + (time > 0L ? "ago" : "after");
        }
        return label;
    }

    public static String convertLebal(Date startTime, Date endTime, boolean showSuffix) {
        if (startTime == null || endTime == null) {
            return EMPTY_SRING;
        }
        long time = (startTime.getTime() - endTime.getTime()) / 1000L;
        Object label = DateUtils.analyzeTime(time, false);
        if (showSuffix) {
            label = (String)label + (time > 0L ? "ago" : "after");
        }
        return label;
    }

    public static String analyzeTime(long time, boolean showFull) {
        Object remark = EMPTY_SRING;
        long tempTime = Math.abs(time);
        if (tempTime < 60L) {
            remark = String.format("%ssecond", tempTime);
        } else if (tempTime < 3600L) {
            remark = String.format("%sbranch%ssecond", tempTime / 60L, tempTime % 60L);
        } else if (tempTime / 3600L < 24L) {
            remark = showFull ? String.format("%shour%sbranch%ssecond", tempTime / 3600L, tempTime / 60L % 60L, tempTime % 60L) : String.format("%shour%sbranch", tempTime / 3600L, tempTime / 60L % 60L);
        } else if (tempTime / 86400L < 30L) {
            remark = showFull ? String.format("%sday%shour%sbranch%ssecond", tempTime / 86400L, tempTime / 3600L % 24L, tempTime / 60L % 60L, tempTime % 60L) : String.format("%sday%shour", tempTime / 86400L, tempTime / 3600L % 24L);
        } else if (tempTime / 2592000L <= 12L) {
            remark = showFull ? String.format("%Months%sday%shour", tempTime / 2592000L, tempTime / 86400L, tempTime / 3600L % 24L) : tempTime / 2592000L + "Months" + tempTime / 86400L % 30L + "day";
        } else if (tempTime / 2592000L < 12L) {
            // empty if block
        }
        return remark;
    }

    public static Date getToday() {
        return DateUtils.rounding(new Date());
    }

    public static Date getYesterday() {
        return DateUtils.rounding(DateUtils.dateAdd(new Date(), -1));
    }

    public static int getBetweenDateDays(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        long to = startTime.getTime();
        long from = endTime.getTime();
        return (int)((from - to) / 86400000L);
    }

    public static Date getTomorrow() {
        return DateUtils.rounding(DateUtils.dateAdd(new Date(), 1));
    }

    public static boolean checkAfterTime(Date date, String time) {
        Date dateTime = DateUtils.convertStringToDate(DateUtils.convertDate(date, "yyyy-MM-dd").concat(" ").concat(time));
        return dateTime.before(date);
    }

    public static String getOffsetStringDate(long offsetTime) {
        int p = offsetTime > 0L ? 1 : -1;
        if ((offsetTime = Math.abs(offsetTime)) < 1000L) {
            return (long)p * offsetTime + "ms";
        }
        if (offsetTime < 60000L) {
            long sec = offsetTime % 86400000L % 3600000L % 60000L / 1000L;
            return (long)p * sec + "s";
        }
        if (offsetTime < 3600000L) {
            long minute = offsetTime % 86400000L % 3600000L / 60000L;
            long sec = offsetTime % 86400000L % 3600000L % 60000L / 1000L;
            if (minute >= 10L) {
                return (long)p * minute + "m";
            }
            return (long)p * minute + "m" + sec + "s";
        }
        long hour = offsetTime % 86400000L / 3600000L;
        long minute = offsetTime % 86400000L % 3600000L / 60000L;
        if (hour >= 5L) {
            return (long)p * hour + "h";
        }
        return (long)p * hour + "h" + minute + "m";
    }

    public static Date dateAddHours(Date startDate, int hours) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        return c.getTime();
    }

    public static Date dateAddMinutes(Date startDate, int minutes) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(12, c.get(12) + minutes);
        return c.getTime();
    }

    public static Date dateAddSeconds(Date startDate, int seconds) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(13, c.get(13) + seconds);
        return c.getTime();
    }

    public static Date dateAddDays(Date startDate, int days) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(5, c.get(5) + days);
        return c.getTime();
    }

    public static Date dateAddMonths(Date startDate, int months) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(2, c.get(2) + months);
        return c.getTime();
    }

    public static Date dateAddYears(Date startDate, int years) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(1, c.get(1) + years);
        return c.getTime();
    }

    public static int dateCompare(Date myDate, Date compareDate) {
        Calendar myCal = Calendar.getInstance();
        Calendar compareCal = Calendar.getInstance();
        myCal.setTime(myDate);
        compareCal.setTime(compareDate);
        return myCal.compareTo(compareCal);
    }

    public static Date dateMin(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtils.dateCompare(date, compareDate)) {
            return compareDate;
        }
        if (-1 == DateUtils.dateCompare(date, compareDate)) {
            return date;
        }
        return date;
    }

    public static Date dateMax(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtils.dateCompare(date, compareDate)) {
            return date;
        }
        if (-1 == DateUtils.dateCompare(date, compareDate)) {
            return compareDate;
        }
        return date;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String timeStamp2DateStr(long time) {
        return DATE_FORMATTER_17.get().format(new Date(time));
    }

    public static String timeStamp2DateStr(long time, String format) {
        if (format == null || format.isEmpty()) {
            format = DEFAULT_TIMESTAMP_PATTERN;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    public static long getTimeZone() {
        return TIME_ZONE;
    }

    public static String getTimeZoneString() {
        return TIME_ZONE_STRING;
    }

    static {
        DATE_FORMATTER_17 = ThreadLocal.withInitial(() -> new SimpleDateFormat(DEFAULT_TIMESTAMP_PATTERN));
        DATE_FORMATTER_14 = ThreadLocal.withInitial(() -> new SimpleDateFormat(DEFAULT_PATTERN));
        Calendar cal = Calendar.getInstance();
        int offset = cal.get(15);
        cal.add(14, -offset);
        long timeStampUTC = cal.getTimeInMillis();
        long timeStamp = System.currentTimeMillis();
        long timeZone = (timeStamp - timeStampUTC) / 3600000L;
        TIME_ZONE = timeZone + 1L;
        TIME_ZONE_STRING = String.valueOf(TIME_ZONE);
    }
}

