/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class DoubleUtils {
    public static final int DEFAULT_SCALE = 8;

    public static BigDecimal createBigDecimal(double value) {
        return BigDecimal.valueOf(value);
    }

    public static double round(double value, int scale, RoundingMode roundingMode) {
        BigDecimal bd = DoubleUtils.createBigDecimal(value);
        bd = bd.setScale(scale, roundingMode);
        return bd.doubleValue();
    }

    public static double round(double value, int scale) {
        return DoubleUtils.round(value, scale, RoundingMode.HALF_UP);
    }

    public static double round(double value) {
        return DoubleUtils.round(value, 8);
    }

    public static String getRoundStr(Double value, int scale, boolean hasThousands) {
        if (null == value) {
            return "";
        }
        StringBuilder suffix = new StringBuilder();
        for (int i = 0; i < scale; ++i) {
            if (i == 0) {
                suffix.append(".");
            }
            suffix.append("0");
        }
        if (hasThousands) {
            return new DecimalFormat("###,##0" + suffix).format(DoubleUtils.round(value, scale));
        }
        return new DecimalFormat("##0" + suffix).format(DoubleUtils.round(value, scale));
    }

    public static String getRoundStr(Double value, int scale) {
        return DoubleUtils.getRoundStr(value, scale, false);
    }

    public static String getRoundStr(Double value) {
        return DoubleUtils.getRoundStr(value, 8, false);
    }

    public static Double parseDouble(String value) {
        if (null == value || "".equals(value.trim())) {
            return null;
        }
        return Double.parseDouble(value.replaceAll(",", "").trim());
    }

    public static Double parseDouble(String value, int scale) {
        if (null == value || "".equals(value.trim())) {
            return null;
        }
        return DoubleUtils.round(Double.parseDouble(value.replaceAll(",", "").trim()), scale);
    }

    public static double sum(double d1, double d2) {
        return DoubleUtils.round(DoubleUtils.createBigDecimal(d1).add(DoubleUtils.createBigDecimal(d2)).doubleValue());
    }

    public static double sum(double d1, BigDecimal d2) {
        return DoubleUtils.round(DoubleUtils.createBigDecimal(d1).add(d2).doubleValue());
    }

    public static double sub(double d1, double d2) {
        return DoubleUtils.round(DoubleUtils.sub(DoubleUtils.createBigDecimal(d1), DoubleUtils.createBigDecimal(d2)).doubleValue());
    }

    public static double sub(double d1, BigDecimal d2) {
        return DoubleUtils.round(DoubleUtils.createBigDecimal(d1).subtract(d2).doubleValue());
    }

    public static double mul(double d1, double d2) {
        return DoubleUtils.mul(DoubleUtils.createBigDecimal(d1), DoubleUtils.createBigDecimal(d2)).doubleValue();
    }

    public static double mul(double d1, BigDecimal d2) {
        return DoubleUtils.createBigDecimal(d1).multiply(d2).doubleValue();
    }

    public static double mul(double d1, double d2, int scale) {
        return DoubleUtils.round(DoubleUtils.mul(DoubleUtils.createBigDecimal(d1), DoubleUtils.createBigDecimal(d2)).doubleValue(), scale);
    }

    public static double div(double d1, double d2, int scale) {
        return DoubleUtils.round(DoubleUtils.div(DoubleUtils.createBigDecimal(d1), DoubleUtils.createBigDecimal(d2)).doubleValue(), scale);
    }

    public static double div(double d1, BigDecimal d2, int scale) {
        return DoubleUtils.round(DoubleUtils.createBigDecimal(d1).divide(d2).doubleValue(), scale);
    }

    public static double div(BigInteger b1, BigInteger b2, int scale) {
        BigDecimal d1 = new BigDecimal(b1);
        BigDecimal d2 = new BigDecimal(b2);
        return DoubleUtils.round(DoubleUtils.div(d1, d2).doubleValue(), scale);
    }

    public static double div(double d1, double d2) {
        return DoubleUtils.div(d1, d2, 8);
    }

    public static double div(double d1, BigDecimal d2) {
        return DoubleUtils.div(d1, d2, 8);
    }

    public static BigDecimal sum(BigDecimal bd1, BigDecimal bd2) {
        return bd1.add(bd2);
    }

    public static BigDecimal sub(BigDecimal bd1, BigDecimal bd2) {
        return bd1.subtract(bd2);
    }

    public static BigDecimal mul(BigDecimal bd1, BigDecimal bd2) {
        return bd1.multiply(bd2);
    }

    public static BigDecimal div(BigDecimal bd1, BigDecimal bd2) {
        if (bd2.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("The divisor cannot be0\uff01");
        }
        return bd1.divide(bd2, 12, RoundingMode.HALF_UP);
    }

    public static BigDecimal sum(BigDecimal bd1, double d2) {
        return DoubleUtils.sum(bd1, DoubleUtils.createBigDecimal(d2));
    }

    public static BigDecimal sub(BigDecimal bd1, double d2) {
        return DoubleUtils.sub(bd1, DoubleUtils.createBigDecimal(d2));
    }

    public static BigDecimal mul(BigDecimal bd1, double d2) {
        return DoubleUtils.mul(bd1, DoubleUtils.createBigDecimal(d2));
    }

    public static BigDecimal div(BigDecimal bd1, double d2) {
        return DoubleUtils.div(bd1, DoubleUtils.createBigDecimal(d2));
    }

    public static double abs(double d1) {
        return Math.abs(d1);
    }

    public static long longValue(double val) {
        return DoubleUtils.createBigDecimal(val).longValue();
    }

    public static int compare(double d1, double d2) {
        return DoubleUtils.createBigDecimal(d1).compareTo(DoubleUtils.createBigDecimal(d2));
    }
}

