/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.parse;

import io.nuls.core.basic.NulsData;
import io.nuls.core.basic.VarInt;
import io.nuls.core.constant.ToolsConstant;
import io.nuls.core.crypto.Sha256Hash;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;

public class SerializeUtils {
    public static final Charset CHARSET = Charset.forName(ToolsConstant.DEFAULT_ENCODING);
    private static final int MAGIC_8 = 8;
    private static final int MAGIC_0X80 = 128;
    public static final String SIGNED_MESSAGE_HEADER = "RiceChain Signed Message:\n";
    public static final byte[] SIGNED_MESSAGE_HEADER_BYTES = "RiceChain Signed Message:\n".getBytes(CHARSET);

    public static BigInteger decodeMPI(byte[] mpi, boolean hasLength) {
        boolean isNegative;
        byte[] buf;
        if (hasLength) {
            int length = (int)SerializeUtils.readUint32BE(mpi, 0);
            buf = new byte[length];
            System.arraycopy(mpi, 4, buf, 0, length);
        } else {
            buf = mpi;
        }
        if (buf.length == 0) {
            return BigInteger.ZERO;
        }
        boolean bl = isNegative = (buf[0] & 0x80) == 128;
        if (isNegative) {
            buf[0] = (byte)(buf[0] & 0x7F);
        }
        BigInteger result = new BigInteger(buf);
        return isNegative ? result.negate() : result;
    }

    public static byte[] encodeMPI(BigInteger value, boolean includeLength) {
        byte[] result;
        boolean isNegative;
        if (value.equals(BigInteger.ZERO)) {
            if (!includeLength) {
                return new byte[0];
            }
            return new byte[]{0, 0, 0, 0};
        }
        boolean bl = isNegative = value.signum() < 0;
        if (isNegative) {
            value = value.negate();
        }
        byte[] array = value.toByteArray();
        int length = array.length;
        if ((array[0] & 0x80) == 128) {
            ++length;
        }
        if (includeLength) {
            byte[] result2 = new byte[length + 4];
            System.arraycopy(array, 0, result2, length - array.length + 3, array.length);
            SerializeUtils.uint32ToByteArrayBE(length, result2, 0);
            if (isNegative) {
                result2[4] = (byte)(result2[4] | 0x80);
            }
            return result2;
        }
        if (length != array.length) {
            result = new byte[length];
            System.arraycopy(array, 0, result, 1, array.length);
        } else {
            result = array;
        }
        if (isNegative) {
            result[0] = (byte)(result[0] | 0x80);
        }
        return result;
    }

    public static byte[] formatMessageForSigning(String message) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(SIGNED_MESSAGE_HEADER_BYTES.length);
            bos.write(SIGNED_MESSAGE_HEADER_BYTES);
            byte[] messageBytes = message.getBytes(CHARSET);
            VarInt size = new VarInt(messageBytes.length);
            bos.write(size.encode());
            bos.write(messageBytes);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static short readUint8LE(byte[] bytes, int offset) {
        return (short)(bytes[offset] & 0xFF);
    }

    public static int readUint16LE(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static int readUint16BE(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static int readUint16(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static long readUint32LE(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
    }

    public static int readInt32LE(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static long readUint32(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
    }

    public static long readUint48(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40;
    }

    public static long readInt64LE(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
    }

    public static long readUint64(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 7] & 0xFFL) << 56;
    }

    public static byte[] int16ToBytes(int x) {
        byte[] bb = new byte[2];
        bb[1] = (byte)(0xFF & x >> 8);
        bb[0] = (byte)(0xFF & x);
        return bb;
    }

    public static byte[] int32ToBytes(int x) {
        byte[] bb = new byte[4];
        bb[3] = (byte)(0xFF & x >> 24);
        bb[2] = (byte)(0xFF & x >> 16);
        bb[1] = (byte)(0xFF & x >> 8);
        bb[0] = (byte)(0xFF & x);
        return bb;
    }

    public static byte[] uint48ToBytes(long val) {
        byte[] bytes = new byte[SerializeUtils.sizeOfUint48()];
        bytes[0] = (byte)(0xFFL & val);
        bytes[1] = (byte)(0xFFL & val >> 8);
        bytes[2] = (byte)(0xFFL & val >> 16);
        bytes[3] = (byte)(0xFFL & val >> 24);
        bytes[4] = (byte)(0xFFL & val >> 32);
        bytes[5] = (byte)(0xFFL & val >> 40);
        return bytes;
    }

    public static byte[] uint64ToByteArray(long val) {
        byte[] out = new byte[]{(byte)(0xFFL & val), (byte)(0xFFL & val >> 8), (byte)(0xFFL & val >> 16), (byte)(0xFFL & val >> 24), (byte)(0xFFL & val >> 32), (byte)(0xFFL & val >> 40), (byte)(0xFFL & val >> 48), (byte)(0xFFL & val >> 56)};
        return out;
    }

    public static byte[] sha256hash160(byte[] input) {
        byte[] sha256 = Sha256Hash.hash(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static void int16ToByteArrayLE(short val, byte[] out, int offset) {
        out[offset] = (byte)(0xFF & val);
        out[offset + 1] = (byte)(0xFF & val >> 8);
    }

    public static void uint32ToByteArrayBE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val >> 24);
        out[offset + 1] = (byte)(0xFFL & val >> 16);
        out[offset + 2] = (byte)(0xFFL & val >> 8);
        out[offset + 3] = (byte)(0xFFL & val);
    }

    public static void uint32ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
    }

    public static void int32ToByteArrayLE(int val, byte[] out, int offset) {
        out[offset] = (byte)(0xFF & val);
        out[offset + 1] = (byte)(0xFF & val >> 8);
        out[offset + 2] = (byte)(0xFF & val >> 16);
        out[offset + 3] = (byte)(0xFF & val >> 24);
    }

    public static void uint64ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset] = (byte)(0xFFL & val);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
        out[offset + 4] = (byte)(0xFFL & val >> 32);
        out[offset + 5] = (byte)(0xFFL & val >> 40);
        out[offset + 6] = (byte)(0xFFL & val >> 48);
        out[offset + 7] = (byte)(0xFFL & val >> 56);
    }

    public static void uint8ToByteStreamLE(short val, OutputStream stream) throws IOException {
        stream.write((short)(0xFF & val));
    }

    public static void int16ToByteStreamLE(short val, OutputStream stream) throws IOException {
        stream.write((byte)(0xFF & val));
        stream.write((byte)(0xFF & val >> 8));
    }

    public static void uint16ToByteStreamLE(int val, OutputStream stream) throws IOException {
        stream.write(0xFF & val);
        stream.write(0xFF & val >> 8);
    }

    public static void uint32ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
    }

    public static void int64ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 32));
        stream.write((int)(0xFFL & val >> 40));
        stream.write((int)(0xFFL & val >> 48));
        stream.write((int)(0xFFL & val >> 56));
    }

    public static void uint64ToByteStreamLE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            throw new RuntimeException("Input too large to encode into a uint64");
        }
        bytes = ByteUtils.reverseBytes(bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i = 0; i < 8 - bytes.length; ++i) {
                stream.write(0);
            }
        }
    }

    public static void doubleToByteStream(double val, OutputStream stream) throws IOException {
        stream.write(ByteUtils.doubleToBytes(val));
    }

    public static int sizeOfDouble(Double val) {
        return 8;
    }

    public static int sizeOfString(String val) {
        byte[] bytes;
        if (null == val) {
            return 1;
        }
        try {
            bytes = val.getBytes(ToolsConstant.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            Log.error(e.getMessage());
            throw new NulsRuntimeException(e);
        }
        return SerializeUtils.sizeOfBytes(bytes);
    }

    public static int sizeOfVarInt(Long val) {
        return VarInt.sizeOf(val);
    }

    public static int sizeOfInt16() {
        return 2;
    }

    public static int sizeOfBigInteger() {
        return 32;
    }

    public static int sizeOfUint16() {
        return 2;
    }

    public static int sizeOfUint8() {
        return 1;
    }

    public static int sizeOfInt32() {
        return 4;
    }

    public static int sizeOfUint32() {
        return 4;
    }

    public static int sizeOfUint48() {
        return ToolsConstant.INT48_VALUE_LENGTH;
    }

    public static int sizeOfInt64() {
        return 8;
    }

    public static int sizeOfVarInt(Integer val) {
        return VarInt.sizeOf(val.intValue());
    }

    public static int sizeOfBoolean() {
        return 1;
    }

    public static int sizeOfNonce() {
        return 8;
    }

    public static int sizeOfBytes(byte[] val) {
        if (null == val) {
            return 1;
        }
        return VarInt.sizeOf(val.length) + val.length;
    }

    public static int sizeOfNulsData(NulsData val) {
        if (null == val) {
            return ToolsConstant.PLACE_HOLDER.length;
        }
        int size = val.size();
        return size == 0 ? 1 : size;
    }

    public static BigInteger bigIntegerFromBytes(byte[] array) {
        array = SerializeUtils.arrayReverse(array);
        return new BigInteger(array);
    }

    public static byte[] bigInteger2Bytes(BigInteger value) {
        byte[] bytes = new byte[32];
        byte[] oBytes = value.toByteArray();
        if ((oBytes = SerializeUtils.arrayReverse(oBytes)).length > 32) {
            throw new RuntimeException("The number is too large!");
        }
        System.arraycopy(oBytes, 0, bytes, 0, oBytes.length);
        return bytes;
    }

    private static byte[] arrayReverse(byte[] bytes) {
        int length = bytes.length;
        byte[] array = new byte[length];
        for (int x = 0; x < length; ++x) {
            array[x] = bytes[length - 1 - x];
        }
        return array;
    }
}

