/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.thread.commom;

import io.nuls.core.thread.ThreadUtils;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NulsThreadFactory
implements ThreadFactory {
    private final String poolName;
    private AtomicInteger threadNo = new AtomicInteger(1);

    public NulsThreadFactory(String poolName) {
        this.poolName = poolName;
    }

    @Override
    public final Thread newThread(Runnable r) {
        Object threadName;
        if (this.threadNo.get() == 1) {
            this.threadNo.incrementAndGet();
            threadName = this.poolName;
        } else {
            threadName = this.poolName + "-" + this.threadNo.getAndIncrement();
        }
        Thread newThread = new Thread(r, (String)threadName);
        if (newThread.getPriority() != 5) {
            newThread.setPriority(5);
        }
        ThreadUtils.putThread(this.poolName, (String)threadName, newThread);
        return newThread;
    }

    public String getPoolName() {
        return this.poolName;
    }
}

