/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.core.thread.commom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadCache {
    private static ThreadCache INSTANCE = null;
    private final Map<String, ThreadPoolExecutor> POOL_EXECUTOR_MAP = new HashMap<String, ThreadPoolExecutor>();
    private final Map<String, Thread> THREAD_MAP = new HashMap<String, Thread>();
    private final Map<String, Set<String>> POOL_THREAD_MAP = new HashMap<String, Set<String>>();

    private ThreadCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ThreadCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ThreadCache> clazz = ThreadCache.class;
        synchronized (ThreadCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ThreadCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public final void putPool(String poolName, ThreadPoolExecutor pool) {
        this.POOL_EXECUTOR_MAP.put(poolName, pool);
    }

    public final void putThread(String poolName, String threadName, Thread thread) {
        this.THREAD_MAP.put(threadName, thread);
        Set<String> set = this.POOL_THREAD_MAP.get(poolName);
        if (null == set) {
            set = new HashSet<String>();
        }
        set.add(threadName);
        this.POOL_THREAD_MAP.put(poolName, set);
    }

    public final Thread getThread(String threadName) {
        return this.THREAD_MAP.get(threadName);
    }

    public final ThreadPoolExecutor getPool(String poolName) {
        return this.POOL_EXECUTOR_MAP.get(poolName);
    }

    public final List<Thread> getThreadList() {
        return new ArrayList<Thread>(this.THREAD_MAP.values());
    }

    public final List<Thread> getThreadList(String poolName) {
        Set<String> set = this.POOL_THREAD_MAP.get(poolName);
        if (null == set) {
            return null;
        }
        ArrayList<Thread> list = new ArrayList<Thread>();
        for (String threadName : set) {
            list.add(this.THREAD_MAP.get(threadName));
        }
        return list;
    }

    public final List<ThreadPoolExecutor> getPoolList() {
        return new ArrayList<ThreadPoolExecutor>(this.POOL_EXECUTOR_MAP.values());
    }

    public void removeAllThread() {
        this.THREAD_MAP.clear();
        this.POOL_EXECUTOR_MAP.clear();
        this.POOL_THREAD_MAP.clear();
    }

    public void removePoolThread(String poolName) {
        this.POOL_THREAD_MAP.remove(poolName);
    }

    public void removeThread(String threadName) {
        this.THREAD_MAP.remove(threadName);
        for (Set<String> tset : this.POOL_THREAD_MAP.values()) {
            tset.remove(threadName);
        }
    }
}

