/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client;

import io.nuls.cmd.client.CommandHandler;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.system.EvalProcessor;
import io.nuls.cmd.client.utils.AssetsUtil;
import io.nuls.cmd.client.utils.LoggerUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.log.logback.NulsLogger;
import io.nuls.core.parse.I18nUtils;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.modulebootstrap.Module;
import io.nuls.core.rpc.modulebootstrap.RpcModule;
import io.nuls.core.rpc.modulebootstrap.RpcModuleState;
import io.nuls.core.thread.ThreadUtils;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@Component
public class CmdClientModule
extends RpcModule {
    int waiting = 1;
    @Autowired
    Config config;
    @Autowired
    CommandHandler commandHandler;
    static NulsLogger log = LoggerUtil.logger;
    @Autowired
    EvalProcessor evalProcessor;

    public Module[] declareDependent() {
        return new Module[]{new Module(ModuleE.NC.abbr, "1.0")};
    }

    public Module moduleInfo() {
        return new Module("cmd-client", "1.0");
    }

    public boolean doStart() {
        System.out.println("waiting nuls-wallet base module ready");
        ThreadUtils.createAndRunThread((String)"", () -> {
            while (!this.isDependencieReady()) {
                ++this.waiting;
                System.out.print(" " + this.waiting);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.waiting <= 59) continue;
                Log.error((String)"waiting nuls-wallet base module ready timeout ");
                System.exit(0);
            }
            return;
        });
        return true;
    }

    public RpcModuleState onDependenciesReady() {
        String evel;
        System.out.println("nuls-wallet base module ready");
        Arrays.stream(this.startArgs).forEach(d -> Log.info((String)"arg:{}", (Object[])new Object[]{d}));
        if (this.startArgs.length > 1 && (evel = this.startArgs[1]).equals(this.evalProcessor.getCommand())) {
            if (this.startArgs.length < 2) {
                System.out.println("param is error");
            }
            String[] cmdAry = this.startArgs[2].split(",");
            Arrays.stream(cmdAry).forEach(cmd -> {
                try {
                    this.commandHandler.processCommand((String)cmd);
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Exception: " + e.getMessage());
                }
            });
            System.exit(0);
        }
        ThreadUtils.createAndRunThread((String)"cmd", () -> this.commandHandler.start());
        if (this.hasDependent(ModuleE.CC)) {
            AssetsUtil.initRegisteredChainInfo();
        }
        return RpcModuleState.Running;
    }

    public RpcModuleState onDependenciesLoss(Module dependenciesModule) {
        return RpcModuleState.Ready;
    }

    public void init() {
        super.init();
        try {
            I18nUtils.setLanguage((String)this.config.getLanguage());
        }
        catch (Exception e) {
            log.error("module init I18nUtils fail", e);
            System.exit(0);
        }
    }
}

