/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client;

import io.nuls.cmd.client.ParameterException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import jline.console.ConsoleReader;

public class CommandHelper {
    public static void checkArgsNumber(String[] args, int ... numbers) throws ParameterException {
        if (!Arrays.stream(numbers).anyMatch(number -> args.length == number)) {
            ParameterException.throwParameterException();
        }
    }

    public static void checkArgs(boolean condition, String message) throws ParameterException {
        if (!condition) {
            ParameterException.throwParameterException(message);
        }
    }

    public static void checkArgs(Supplier<Boolean> check, String message) throws ParameterException {
        if (!check.get().booleanValue()) {
            ParameterException.throwParameterException(message);
        }
    }

    public static boolean checkArgsIsNull(String ... args) {
        for (String arg : args) {
            if (arg != null && arg.trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean confirmPwd(String newPwd) {
        System.out.print("Please confirm new password:");
        ConsoleReader reader = null;
        int i = 3;
        boolean passed = true;
        try {
            reader = new ConsoleReader();
            String confirmed = null;
            do {
                if (--i < 0) {
                    passed = false;
                    break;
                }
                confirmed = reader.readLine(Character.valueOf('*'));
                if (newPwd.equals(confirmed)) continue;
                System.out.print("Password confirmation doesn't match the password.\nConfirm new password:");
            } while (!newPwd.equals(confirmed));
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return passed;
    }

    public static String getPwd() {
        return CommandHelper.getPwd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPwd(String prompt) {
        if (StringUtils.isBlank((String)prompt)) {
            prompt = "Please enter the password.\nEnter your password:";
        }
        System.out.print(prompt);
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            String npwd = null;
            do {
                if (!"".equals(npwd = reader.readLine(Character.valueOf('*')))) continue;
                System.out.print("The password is required.\nEnter your password:");
            } while ("".equals(npwd));
            String string = npwd;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPwdOptional(String prompt) {
        if (StringUtils.isBlank((String)prompt)) {
            prompt = "Please enter the password (password is between 8 and 20 inclusive of numbers and letters), If you do not want to set a password, return directly.\nEnter your password:";
        }
        System.out.print(prompt);
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            String npwd = null;
            do {
                if ("".equals(npwd = reader.readLine(Character.valueOf('*'))) || CommandHelper.validPassword(npwd)) continue;
                System.out.print("Password invalid, password is between 8 and 20 inclusive of numbers and letters.\nEnter your password:");
            } while (!"".equals(npwd) && !CommandHelper.validPassword(npwd));
            String string = npwd;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean validPassword(String password) {
        if (StringUtils.isBlank((String)password)) {
            return false;
        }
        if (password.length() < 8 || password.length() > 20) {
            return false;
        }
        return password.matches("(.*)[a-zA-z](.*)") && password.matches("(.*)\\d+(.*)") && !password.matches("(.*)\\s+(.*)") && !password.matches("(.*)[\u4e00-\u9fa5\u3000]+(.*)");
    }

    public static String getPwdOptional() {
        return CommandHelper.getPwdOptional(null);
    }

    public static String txTypeExplain(Integer type) {
        if (null == type) {
            return null;
        }
        switch (type) {
            case 1: {
                return "coinbase";
            }
            case 2: {
                return "transfer";
            }
            case 3: {
                return "account_alias";
            }
            case 4: {
                return "register_agent";
            }
            case 5: {
                return "join_consensus";
            }
            case 6: {
                return "cancel_deposit";
            }
            case 7: {
                return "yellow_punish";
            }
            case 8: {
                return "red_punish";
            }
            case 9: {
                return "stop_agent";
            }
        }
        return type.toString();
    }

    public static String consensusExplain(Integer status) {
        if (null == status) {
            return null;
        }
        switch (status) {
            case 0: {
                return "unconsensus";
            }
            case 1: {
                return "consensus";
            }
        }
        return status.toString();
    }

    public static String statusConfirmExplain(Integer status) {
        if (null == status) {
            return null;
        }
        switch (status) {
            case 0: {
                return "confirm";
            }
            case 1: {
                return "unConfirm";
            }
        }
        return status.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getArgsJson() {
        String prompt = "Please enter the arguments according to the arguments structure(eg. \"a\",2,[\"c\",4],\"\",\"e\" or \"'a',2,['c',4],'','e'\"),\nIf this method has no arguments(Refer to the command named \"getcontractinfo\" for the arguments structure of the method.), return directly.\nEnter the arguments:";
        System.out.print(prompt);
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            Object args = reader.readLine();
            if (StringUtils.isNotBlank((String)args)) {
                args = "[" + (String)args + "]";
            }
            String string = args;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Object[] parseArgsJson(String argsJson) {
        if (StringUtils.isBlank((String)argsJson)) {
            return new Object[0];
        }
        try {
            List list = (List)JSONUtils.json2pojo((String)argsJson, ArrayList.class);
            return list.toArray();
        }
        catch (Exception e) {
            System.out.println("arguments format error (eg. \"a\",2,[\"c\",4],\"\",\"e\" or \"'a',2,['c',4],'','e'\")");
            return null;
        }
    }
}

