/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor;

import io.nuls.base.api.provider.Result;
import io.nuls.base.basic.AddressTool;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.ParameterException;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.core.log.Log;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;

public interface CommandProcessor {
    public static final Pattern IS_NUMBERIC = Pattern.compile("[0-9]+");
    public static final Pattern IS_AMOUNT = Pattern.compile("(^[0-9]+$)|(^[0-9]+([.]{1}[0-9]{0,8}))$");

    default public void checkArgsNumber(String[] args, int ... numbers) throws ParameterException {
        if (!Arrays.stream(numbers).anyMatch(number -> args.length - 1 == number)) {
            ParameterException.throwParameterException();
        }
    }

    default public void checkArgs(boolean condition, String message) throws ParameterException {
        if (!condition) {
            ParameterException.throwParameterException(message);
        }
    }

    default public void checkAddress(int chainId, String ... addressList) throws ParameterException {
        for (String address : addressList) {
            this.checkArgs(AddressTool.validAddress((int)chainId, (String)address), "address format error");
        }
    }

    default public void checkIsNumeric(String arg, String name) {
        Matcher matcher = IS_NUMBERIC.matcher(arg);
        if (!matcher.matches()) {
            ParameterException.throwParameterException(name + " must be a numeric");
        }
    }

    default public void checkIsAmount(String arg, String name) {
        BigDecimal amount;
        Matcher matcher = IS_AMOUNT.matcher(arg);
        if (!matcher.find()) {
            ParameterException.throwParameterException(name + " must be a numeric");
        }
        if ((amount = new BigDecimal(arg)).compareTo(BigDecimal.valueOf(0.01)) < 0) {
            ParameterException.throwParameterException(name + " must be a numeric and greater than 0.01");
        }
    }

    default public void checkArgs(Supplier<Boolean> check, String message) throws ParameterException {
        if (!check.get().booleanValue()) {
            ParameterException.throwParameterException(message);
        }
    }

    default public String getPwd() {
        return this.getPwd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String getPwd(String prompt) {
        if (StringUtils.isBlank((String)prompt)) {
            prompt = "Please enter the password.\nEnter your password:";
        }
        System.out.print(prompt);
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            String npwd = null;
            do {
                if (!"".equals(npwd = reader.readLine(Character.valueOf('*')))) continue;
                System.out.print("The password is required.\nEnter your password:");
            } while ("".equals(npwd));
            String string = npwd;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    default public Result dataTransformList(Result rpcResult) {
        rpcResult.setData((Object)rpcResult.getList());
        return rpcResult;
    }

    default public CommandResult getResult(Result rpcResult) {
        if (null == rpcResult) {
            return CommandResult.getFailed("Result is null!");
        }
        CommandResult result = new CommandResult();
        result.setSuccess(rpcResult.isSuccess());
        Object message = "";
        if (!rpcResult.isSuccess()) {
            Map map = (Map)rpcResult.getData();
            message = (String)map.get("msg");
        } else {
            try {
                message = rpcResult.getData() != null ? (String)message + JSONUtils.obj2PrettyJson((Object)rpcResult.getData()) : (rpcResult.getList() != null ? (String)message + JSONUtils.obj2PrettyJson((Object)rpcResult.getList()) : (String)message + "success");
            }
            catch (Exception e) {
                Log.error((String)"return data format exception :", (Throwable)e);
            }
        }
        result.setMessage((String)message);
        return result;
    }

    public String getCommand();

    public CommandGroup getGroup();

    public String getHelp();

    public String getCommandDescription();

    public boolean argsValidate(String[] var1);

    public CommandResult execute(String[] var1);
}

