/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.GenerateMultiSignAccountReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import java.util.Arrays;

@Component
public class CreateMultiAccountProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Override
    public String getCommand() {
        return "createmultisignaccount";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<pubKeys> List of public keys participating in multiple signatures, using multiple signatures\",\"Separate").newLine("\t[minSigns] Minimum number of signatures, default to all");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createmultisignaccount <pubKeys> --create multi sign account";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1, 2);
        if (args.length == 2) {
            return true;
        }
        this.checkArgs(StringUtils.isNumeric((String)args[2]), "must enter a number");
        this.checkArgs(Integer.parseInt(args[2]) > 0, "must be greater than zero");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        GenerateMultiSignAccountReq req = new GenerateMultiSignAccountReq();
        req.setPubKeys(Arrays.asList(args[1].split(",")));
        if (args.length == 3) {
            req.setMinSigns(Integer.parseInt(args[2]));
        } else {
            req.setMinSigns(req.getPubKeys().size());
        }
        Result result = this.accountService.createMultiSignAccount(req);
        if (!result.isSuccess()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }

    public static void main(String[] args) {
        System.out.println(AddressTool.isMultiSignAddress((String)"tNULSeBaMt7BiJcdHNXxpos7gDt6XpwY15NKmi"));
    }
}

