/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.account.facade.AccountInfo;
import io.nuls.base.api.provider.account.facade.GetAccountByAddressReq;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.AccountBalanceInfo;
import io.nuls.base.api.provider.ledger.facade.GetBalanceReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.log.Log;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.parse.MapUtils;
import java.math.BigDecimal;
import java.util.HashMap;

@Component
public class GetAccountProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "getaccount";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> the account address - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getaccount <address> --get account information";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        Result info = this.accountService.getAccountByAddress(new GetAccountByAddressReq(address));
        if (info.isFailed()) {
            return CommandResult.getFailed(info);
        }
        Result balance = this.ledgerProvider.getBalance(new GetBalanceReq(this.config.getAssetsId(), this.config.getChainId(), address));
        if (balance.isFailed()) {
            return CommandResult.getFailed(balance);
        }
        HashMap res = new HashMap(7);
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>(3);
        balanceMap.put("available", this.config.toBigUnit(((AccountBalanceInfo)balance.getData()).getAvailable()));
        balanceMap.put("freeze", this.config.toBigUnit(((AccountBalanceInfo)balance.getData()).getFreeze()));
        balanceMap.put("total", this.config.toBigUnit(((AccountBalanceInfo)balance.getData()).getTotal()));
        res.putAll(MapUtils.beanToMap((Object)((AccountInfo)info.getData())));
        res.put("balance", balanceMap);
        try {
            return CommandResult.getSuccess(JSONUtils.obj2PrettyJson(res));
        }
        catch (JsonProcessingException e) {
            Log.error((String)"", (Throwable)e);
            return null;
        }
    }
}

