/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.account;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.account.facade.SetAccountAliasReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.account.AccountBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.FormatValidUtils;

@Component
public class SetAliasProcessor
extends AccountBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "setalias";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> The address of the account, - Required").newLine("\t<alias> The alias of the account, the bytes for the alias is between 1 and 20 (only lower case letters, Numbers and underline, the underline should not be at the begin and end), - Required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "setalias <address> <alias>  --Set an alias for the account ";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkArgs(FormatValidUtils.validAlias((String)args[2]), "alias format error");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        String alias = args[2];
        String password = this.getPwd();
        Result result = this.accountService.setAccountAlias(new SetAccountAliasReq(password, address, alias));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess("txHash:" + (String)result.getData());
    }
}

