/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.consensus.facade.AgentInfo;
import io.nuls.base.api.provider.consensus.facade.GetAgentInfoReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class GetAgentInfoProcessor
extends ConsensusBaseProcessor {
    @Override
    public String getCommand() {
        return "getagent";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<agentHash>  the hash of an agent -required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getagent <agentHash>  -- get an agent node information According to agent hash";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs(NulsHash.validHash((String)args[1]), "agentHash format error");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String agentHash = args[1];
        Result result = this.consensusProvider.getAgentInfo(new GetAgentInfoReq(agentHash));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        AgentInfo info = (AgentInfo)result.getData();
        return CommandResult.getResult(new Result(this.agentToMap(info)));
    }
}

