/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.consensus.facade.GetAgentListReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import java.util.List;
import java.util.stream.Collectors;

@Component
public class GetAgentsProcessor
extends ConsensusBaseProcessor {
    @Override
    public String getCommand() {
        return "getagents";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<pageNumber> pageNumber - Required").newLine("\t<pageSize> pageSize(1~100) - Required").newLine("\t[keyWord]");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getagents <pageNumber> <pageSize> [keyWord] --get agent list";
    }

    @Override
    public boolean argsValidate(String[] args) {
        int length = args.length;
        if (length != 3 && length != 4) {
            return false;
        }
        if (!CommandHelper.checkArgsIsNull(args)) {
            return false;
        }
        if (!StringUtils.isNumeric((String)args[1]) || !StringUtils.isNumeric((String)args[2])) {
            return false;
        }
        this.checkArgsNumber(args, 2, 3);
        this.checkIsNumeric(args[1], "pageNumber");
        this.checkIsNumeric(args[2], "pageSize");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        int pageNumber = Integer.parseInt(args[1]);
        int pageSize = Integer.parseInt(args[2]);
        String keyWord = null;
        if (args.length == 4) {
            keyWord = args[3];
        }
        GetAgentListReq req = new GetAgentListReq();
        req.setPageNumber(pageNumber);
        req.setPageSize(pageSize);
        req.setKeyWord(keyWord);
        Result result = this.consensusProvider.getAgentList(req);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        List list = result.getList().stream().map(this::agentToMap).collect(Collectors.toList());
        return CommandResult.getResult(CommandResult.dataTransformList(new Result(list)));
    }
}

