/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.consensus;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.consensus.ConsensusProvider;
import io.nuls.base.api.provider.consensus.facade.WithdrawReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.consensus.ConsensusBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;

@Component
public class WithdrawProcessor
extends ConsensusBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;
    ConsensusProvider consensusProvider = (ConsensusProvider)ServiceManager.get(ConsensusProvider.class);

    @Override
    public String getCommand() {
        return "withdraw";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<address>   address -required").newLine("\t<txHash>    your deposit transaction hash  -required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "withdraw <address> <txHash> -- withdraw the agent";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 2);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkArgs(NulsHash.validHash((String)args[2]), "txHash format error");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String address = args[1];
        String txHash = args[2];
        String password = this.getPwd();
        Result result = this.consensusProvider.withdraw(new WithdrawReq(address, txHash, password));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess(result);
    }
}

