/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.CreateContractReq;
import io.nuls.base.api.provider.contract.facade.GetContractConstructorArgsReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;

@Component
public class CreateContractProcessor
extends ContractBaseProcessor {
    private ThreadLocal<CreateContractReq> paramsData = new ThreadLocal();

    @Override
    public String getCommand() {
        return "createcontract";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<sender>         source address    -required").newLine("\t<gasLimit>       gas limit    -required").newLine("\t<price>          price (Unit: Na/Gas)    -required").newLine("\t<contractCode>   contract code    -required").newLine("\t<alias>          contract alias    -required").newLine("\t[remark]         remark    -not required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "createcontract <sender> <gasLimit> <price> <contractCode> <alias> [remark] --create contract";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 4, 5);
        this.checkAddress(this.config.getChainId(), args[1]);
        this.checkIsNumeric(args[2], "gasLimit");
        this.checkIsNumeric(args[3], "price");
        CreateContractReq form = this.getContractCreate(args);
        if (null == form) {
            return false;
        }
        this.paramsData.set(form);
        return true;
    }

    private CreateContractReq getContractCreate(String[] args) {
        CreateContractReq create = null;
        try {
            create = new CreateContractReq();
            create.setSender(args[1].trim());
            create.setGasLimit(Long.valueOf(args[2].trim()).longValue());
            create.setPrice(Long.valueOf(args[3].trim()).longValue());
            create.setContractCode(args[4].trim());
            create.setAlias(args[5].trim());
            if (args.length == 7) {
                create.setRemark(args[6].trim());
            }
            return create;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public CommandResult execute(String[] args) {
        CreateContractReq form = this.paramsData.get();
        if (null == form) {
            form = this.getContractCreate(args);
        }
        if (null == form) {
            return CommandResult.getFailed("parameter error.");
        }
        String password = CommandHelper.getPwd();
        String contractCode = form.getContractCode();
        Result<Object[]> res = this.createContractArgs(contractCode);
        if (!res.isSuccess()) {
            return CommandResult.getFailed(res);
        }
        form.setArgs((Object[])res.getData());
        form.setPassword(password);
        Result result = this.contractProvider.createContract(form);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }

    private Result<Object[]> createContractArgs(String contractCode) {
        GetContractConstructorArgsReq req = new GetContractConstructorArgsReq(contractCode);
        Result result = this.contractProvider.getContractConstructorArgs(req);
        if (result.isSuccess()) {
            Result rpcClientResult = new Result();
            try {
                Object[] argsObj;
                Map map = (Map)result.getData();
                Map constructorMap = (Map)map.get("constructor");
                List argsList = (List)constructorMap.get("args");
                if (argsList.size() > 0) {
                    String argsListStr = JSONUtils.obj2PrettyJson((Object)argsList);
                    String argsJson = this.getArgsJson(argsListStr);
                    argsObj = CommandHelper.parseArgsJson(argsJson);
                } else {
                    argsObj = new Object[]{};
                }
                rpcClientResult.setData((Object)argsObj);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Result.fail((String)ErrorCodeConstants.PARAM_ERR.getCode(), (String)ErrorCodeConstants.PARAM_ERR.getMsg());
            }
            return rpcClientResult;
        }
        return Result.fail((String)ErrorCodeConstants.SYSTEM_ERR.getCode(), (String)ErrorCodeConstants.SYSTEM_ERR.getMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArgsJson(String constructor) {
        System.out.println("The arguments structure: ");
        System.out.println(constructor);
        String prompt = "Please enter the arguments you want to fill in according to the arguments structure(eg. \"a\",2,[\"c\",4],\"\",\"e\" or \"'a',2,['c',4],'','e'\").\nEnter the arguments:";
        System.out.print(prompt);
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            Object args = reader.readLine();
            if (StringUtils.isNotBlank((String)args)) {
                args = "[" + (String)args + "]";
            }
            String string = args;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (!reader.delete()) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

