/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.GetContractTxReq;
import io.nuls.base.data.NulsHash;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.cmd.client.utils.Na;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.util.NulsDateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Component
public class GetContractTxProcessor
extends ContractBaseProcessor {
    @Override
    public String getCommand() {
        return "getcontracttx";
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine(this.getCommandDescription()).newLine("\t<hash>  transaction hash -required");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getcontracttx <hash> --get the contract transaction information by txhash";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs(NulsHash.validHash((String)args[1]), "hash format error");
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Map contractResultMap;
        Map dataMap;
        String hash = args[1];
        if (StringUtils.isBlank((String)hash)) {
            return CommandResult.getFailed(ErrorCodeConstants.PARAM_ERR.getMsg());
        }
        Result result = this.contractProvider.getContractTx(new GetContractTxReq(hash));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        Map map = (Map)result.getData();
        map.put("fee", Na.naToNuls(map.get("fee"), this.config.getDecimals()));
        map.put("value", Na.naToNuls(map.get("value"), this.config.getDecimals()));
        map.put("time", NulsDateUtils.convertDate((Date)new Date(Long.valueOf(String.valueOf(map.get("time"))))));
        map.put("status", this.statusExplain((Integer)map.get("status")));
        map.put("type", CommandHelper.txTypeExplain((Integer)map.get("type")));
        List inputs = (List)map.get("inputs");
        for (Object input : inputs) {
            input.put("value", Na.naToNuls(input.get("value"), this.config.getDecimals()));
        }
        map.put("inputs", inputs);
        List outputs = (List)map.get("outputs");
        for (Map output : outputs) {
            output.put("value", Na.naToNuls(output.get("value"), this.config.getDecimals()));
        }
        map.put("outputs", outputs);
        Map txDataMap = (Map)map.get("txData");
        if (txDataMap != null && (dataMap = (Map)txDataMap.get("data")) != null) {
            dataMap.put("value", Na.naToNuls(dataMap.get("value"), this.config.getDecimals()));
            dataMap.put("price", Na.naToNuls(dataMap.get("price"), this.config.getDecimals()));
        }
        if ((contractResultMap = (Map)map.get("contractResult")) != null) {
            contractResultMap.put("totalFee", Na.naToNuls(contractResultMap.get("totalFee"), this.config.getDecimals()));
            contractResultMap.put("txSizeFee", Na.naToNuls(contractResultMap.get("txSizeFee"), this.config.getDecimals()));
            contractResultMap.put("actualContractFee", Na.naToNuls(contractResultMap.get("actualContractFee"), this.config.getDecimals()));
            contractResultMap.put("refundFee", Na.naToNuls(contractResultMap.get("refundFee"), this.config.getDecimals()));
            contractResultMap.put("value", Na.naToNuls(contractResultMap.get("value"), this.config.getDecimals()));
            contractResultMap.put("price", Na.naToNuls(contractResultMap.get("price"), this.config.getDecimals()));
        }
        result.setData((Object)map);
        return CommandResult.getResult(result);
    }

    private String statusExplain(Integer status) {
        if (status == 0) {
            return "unConfirm";
        }
        if (status == 1) {
            return "confirm";
        }
        return "unknown";
    }

    private String statusExplainForOutPut(Integer status) {
        if (status == null) {
            return "unknown";
        }
        if (status == 0) {
            return "usable";
        }
        if (status == 1) {
            return "timeLock";
        }
        if (status == 2) {
            return "consensusLock";
        }
        if (status == 3) {
            return "spent";
        }
        return "unknown";
    }
}

