/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.contract;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.contract.facade.GetContractInfoReq;
import io.nuls.base.api.provider.contract.facade.TokenTransferReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.contract.ContractBaseProcessor;
import io.nuls.core.core.annotation.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

@Component
public class TokenTransferProcessor
extends ContractBaseProcessor {
    private TokenTransferReq paramsData = new TokenTransferReq();

    @Override
    public String getCommand() {
        return "tokentransfer";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address>           source address - Required").newLine("\t<toaddress>         receiving address - Required").newLine("\t<contractAddress>   contract address    -Required").newLine("\t<amount>            amount, you can have up to [decimals of the contract] valid digits after the decimal point - Required").newLine("\t[remark]            remark -not required");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "tokentransfer <address> <toAddress> <contractAddress> <amount> [remark] --token transfer";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 4, 5);
        this.checkAddress(this.config.getChainId(), args[1], args[2], args[3]);
        this.checkIsAmount(args[4], "amount");
        TokenTransferReq form = this.getTokenTransferForm(args);
        if (null == form) {
            return false;
        }
        this.paramsData = form;
        return true;
    }

    private TokenTransferReq getTokenTransferForm(String[] args) {
        TokenTransferReq transfer = null;
        try {
            transfer = new TokenTransferReq();
            transfer.setAddress(args[1].trim());
            transfer.setToAddress(args[2].trim());
            transfer.setContractAddress(args[3].trim());
            transfer.setAmount(args[4].trim());
            if (args.length == 6) {
                transfer.setRemark(args[5].trim());
            }
            return transfer;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public CommandResult execute(String[] args) {
        TokenTransferReq form = this.paramsData;
        if (null == form) {
            form = this.getTokenTransferForm(args);
        }
        String address = form.getAddress();
        String password = CommandHelper.getPwd();
        String contractAddress = form.getContractAddress();
        String url = "/contract/" + contractAddress;
        Result contract = this.contractProvider.getContractInfo(new GetContractInfoReq(contractAddress));
        if (contract.isFailed()) {
            return CommandResult.getFailed(contract);
        }
        Boolean isNrc20 = (Boolean)((Map)contract.getData()).get("nrc20");
        if (!isNrc20.booleanValue()) {
            return CommandResult.getFailed("Non-NRC20 contract, can not transfer token.");
        }
        Integer decimals = (Integer)((Map)contract.getData()).get("decimals");
        BigDecimal amountBigD = new BigDecimal(form.getAmount()).multiply(BigDecimal.TEN.pow(decimals));
        try {
            BigInteger amountBigI = amountBigD.toBigIntegerExact();
            form.setAmount(amountBigI.toString());
        }
        catch (Exception e) {
            return CommandResult.getFailed("Illegal amount, you can have up to " + decimals + " valid digits after the decimal point.");
        }
        form.setPassword(password);
        Result result = this.contractProvider.tokenTransfer(form);
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(result);
    }
}

