/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.crosschain;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.crosschain.facade.CreateResetLocalVerifierTxReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.crosschain.CrossChainBaseProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class ResetLocalVerifierTxProcessor
extends CrossChainBaseProcessor {
    @Override
    public String getCommand() {
        return "resetlocalverifier";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address>  address - require").newLine("\t[password] \t\tpassword");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "resetlocalverifier <address> [password]--create cross chain tx";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1, 2);
        this.checkAddress(this.config.getChainId(), args[1]);
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Integer chainId = this.config.getChainId();
        String address = args[1];
        String password = null;
        password = args.length == 3 ? args[2] : this.getPwd();
        Result result = this.crossChainProvider.resetLocalVerifier(new CreateResetLocalVerifierTxReq(address, password));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

