/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.ledger;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.ledger.facade.AccountBalanceInfo;
import io.nuls.base.api.provider.ledger.facade.GetBalanceReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.utils.AssetsUtil;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

@Component
public class GetBalanceProcessor
implements CommandProcessor {
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "getbalance";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.Ledger;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<address> the account address - require").newLine("\t[assetChainId] the asset chain id - require").newLine("\t<assetId> the asset id - require");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "getbalance <address> [assetChainId] [assetId]--get the balance of a address";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1, 3);
        this.checkAddress(this.config.getChainId(), args[1]);
        if (args.length == 4) {
            this.checkIsNumeric(args[2], "asset chain id ");
            this.checkIsNumeric(args[3], "asset id");
        }
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result;
        String address = args[1];
        Integer assetChainId = this.config.getChainId();
        Integer assetId = this.config.getAssetsId();
        if (args.length == 4) {
            assetChainId = Integer.parseInt(args[2]);
            assetId = Integer.parseInt(args[3]);
        }
        if ((result = this.ledgerProvider.getBalance(new GetBalanceReq(assetId, assetChainId, address))).isFailed()) {
            return CommandResult.getFailed(result);
        }
        Integer decimalInt = AssetsUtil.getCrossAssetDecimal(assetChainId, assetId);
        HashMap<String, BigDecimal> r = new HashMap<String, BigDecimal>(3);
        r.put("available", AssetsUtil.toBigUnit(((AccountBalanceInfo)result.getData()).getAvailable(), decimalInt));
        r.put("freeze", AssetsUtil.toBigUnit(((AccountBalanceInfo)result.getData()).getFreeze(), decimalInt));
        r.put("total", AssetsUtil.toBigUnit(((AccountBalanceInfo)result.getData()).getTotal(), decimalInt));
        return CommandResult.getSuccess(new Result(r));
    }

    public static void main(String[] args) {
        System.out.println(BigInteger.TEN.pow(10));
    }
}

