/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.network;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.network.NetworkProvider;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Component;

@Component
public class GetNetworkProcessor
implements CommandProcessor {
    NetworkProvider networkProvider = (NetworkProvider)ServiceManager.get(NetworkProvider.class);

    @Override
    public String getCommand() {
        return "network";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.System;
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription());
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "network info --get network info \nnetwork nodes --get network nodes";
    }

    @Override
    public boolean argsValidate(String[] args) {
        this.checkArgsNumber(args, 1);
        this.checkArgs("info".equals(args[1]) || "nodes".equals(args[1]), this.getCommandDescription());
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        String cmd = args[1];
        if ("info".equals(cmd)) {
            Result result = this.networkProvider.getInfo();
            if (result.isFailed()) {
                return CommandResult.getFailed(result);
            }
            return CommandResult.getSuccess(result);
        }
        Result result = this.networkProvider.getNodesInfo();
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getResult(CommandResult.dataTransformList(result));
    }
}

