/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.system;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.protocol.ProtocolProvider;
import io.nuls.base.api.provider.protocol.facade.GetVersionReq;
import io.nuls.base.api.provider.protocol.facade.VersionInfo;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandGroup;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.parse.MapUtils;
import java.util.Map;

@Component
public class VersionProcessor
implements CommandProcessor {
    ProtocolProvider transferService = (ProtocolProvider)ServiceManager.get(ProtocolProvider.class);
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "version";
    }

    @Override
    public CommandGroup getGroup() {
        return CommandGroup.System;
    }

    @Override
    public String getHelp() {
        CommandBuilder bulider = new CommandBuilder();
        bulider.newLine("version -- print node version info");
        return bulider.toString();
    }

    @Override
    public String getCommandDescription() {
        return "version";
    }

    @Override
    public boolean argsValidate(String[] args) {
        return true;
    }

    @Override
    public CommandResult execute(String[] args) {
        Result res = this.transferService.getVersion(new GetVersionReq());
        if (this.config.getClientVersion() != null) {
            Map m = MapUtils.beanToLinkedMap((Object)((VersionInfo)res.getData()));
            m.put("clientVersion", this.config.getClientVersion());
            return CommandResult.getSuccess(new Result((Object)m));
        }
        return CommandResult.getSuccess(res);
    }
}

