/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.processor.transaction;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.cmd.client.CommandBuilder;
import io.nuls.cmd.client.CommandHelper;
import io.nuls.cmd.client.CommandResult;
import io.nuls.cmd.client.config.Config;
import io.nuls.cmd.client.processor.CommandProcessor;
import io.nuls.cmd.client.processor.transaction.TransactionBaseProcessor;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.model.StringUtils;
import java.math.BigInteger;

@Component
@Deprecated
public class TransferByAliasProcessor
extends TransactionBaseProcessor
implements CommandProcessor {
    @Autowired
    Config config;

    @Override
    public String getCommand() {
        return "transferbyalias";
    }

    @Override
    public String getHelp() {
        CommandBuilder builder = new CommandBuilder();
        builder.newLine(this.getCommandDescription()).newLine("\t<alias> \t\tsource alias - Required").newLine("\t<toaddress> \treceiving address - Required").newLine("\t<amount> \t\tamount, you can have up to 8 valid digits after the decimal point - Required").newLine("\t[remark] \t\tremark - ");
        return builder.toString();
    }

    @Override
    public String getCommandDescription() {
        return "transferbyalias <alias> <toAddress> <amount> [remark] --transfer";
    }

    @Override
    public boolean argsValidate(String[] args) {
        BigInteger amount;
        int length = args.length;
        boolean result = length != 4 && length != 5 ? false : (!CommandHelper.checkArgsIsNull(args) ? false : (!StringUtils.isNuls((String)args[3]) ? false : (amount = new BigInteger(args[3])).compareTo(BigInteger.ZERO) > 0));
        return result;
    }

    private TransferReq buildTransferReq(String[] args) {
        String formAddress = args[1];
        String toAddress = args[2];
        BigInteger amount = new BigInteger(args[3]);
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(this.config.getChainId(), this.config.getAssetsId()).addForm(formAddress, this.getPwd("Enter your account password:"), amount).addTo(toAddress, amount);
        if (args.length == 5) {
            builder.setRemark(args[4]);
        }
        return builder.build(new TransferReq());
    }

    @Override
    public CommandResult execute(String[] args) {
        Result result = this.transferService.transferByAlias(this.buildTransferReq(args));
        if (result.isFailed()) {
            return CommandResult.getFailed(result);
        }
        return CommandResult.getSuccess((String)result.getData());
    }
}

