/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.cmd.client.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.nuls.cmd.client.processor.ErrorCodeConstants;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.log.Log;
import io.nuls.core.model.LongUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class Na
implements Comparable<Na>,
Serializable {
    private static final long serialVersionUID = 6978149202334427537L;
    public static final int SMALLEST_UNIT_EXPONENT = 8;
    private static final NumberFormat numberFormat = new DecimalFormat("###.00######");
    public static final long NA_VALUE = (long)Math.pow(10.0, 8.0);
    public static final long TOTAL_VALUE = 100000000L;
    public static final long MAX_NA_VALUE = LongUtils.mul((long)100000000L, (long)((long)Math.pow(10.0, 8.0)));
    public static final Na MAX = Na.valueOf(100000000L).multiply(NA_VALUE);
    public static final Na ZERO = Na.valueOf(0L);
    public static final Na NA = Na.valueOf(NA_VALUE);
    public static final Na CENT = NA.divide(100L);
    public static final Na MILLICOIN = NA.divide(1000L);
    public static final Na MICROCOIN = MILLICOIN.divide(1000L);
    private final long value;

    private Na(long na) {
        if (MAX_NA_VALUE < na || na < 0L) {
            throw new NulsRuntimeException(ErrorCodeConstants.DATA_ERROR);
        }
        this.value = na;
    }

    public static Na valueOf(BigInteger na) {
        return Na.valueOf(na.longValue());
    }

    public static Na valueOf(long na) {
        if (MAX_NA_VALUE < na) {
            throw new NulsRuntimeException(ErrorCodeConstants.DATA_ERROR);
        }
        return new Na(na);
    }

    public int smallestUnitExponent() {
        return 8;
    }

    public long getValue() {
        return this.value;
    }

    public static Na parseNuls(String str) {
        try {
            long value = new BigDecimal(str).movePointRight(8).setScale(8, RoundingMode.HALF_DOWN).longValue();
            return Na.valueOf(value);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Na parseNuls(double nuls) {
        try {
            long value = new BigDecimal(nuls).movePointRight(8).setScale(8, RoundingMode.HALF_DOWN).longValue();
            return Na.valueOf(value);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double toDouble() {
        return new BigDecimal(this.value).movePointLeft(8).setScale(8, RoundingMode.HALF_DOWN).doubleValue();
    }

    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public Na add(Na value) {
        return new Na(LongUtils.add((long)this.value, (long)value.value));
    }

    public Na plus(Na value) {
        return this.add(value);
    }

    public Na subtract(Na value) {
        return new Na(LongUtils.sub((long)this.value, (long)value.value));
    }

    public Na minus(Na value) {
        return this.subtract(value);
    }

    public Na multiply(long factor) {
        return new Na(LongUtils.mul((long)this.value, (long)factor));
    }

    public Na times(long factor) {
        return this.multiply(factor);
    }

    public Na times(int factor) {
        return this.multiply(factor);
    }

    public Na divide(long divisor) {
        return new Na(LongUtils.div((long)this.value, (long)divisor));
    }

    public Na div(long divisor) {
        return this.divide(divisor);
    }

    public Na div(int divisor) {
        return this.divide(divisor);
    }

    public Na[] divideAndRemainder(long divisor) {
        return new Na[]{new Na(LongUtils.div((long)this.value, (long)divisor)), new Na(LongUtils.mod((long)this.value, (long)divisor))};
    }

    public long divide(Na divisor) {
        return LongUtils.div((long)this.value, (long)divisor.value);
    }

    @JsonIgnore
    public boolean isPositive() {
        return this.signum() == 1;
    }

    @JsonIgnore
    public boolean isNegative() {
        return this.signum() == -1;
    }

    @JsonIgnore
    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isGreaterThan(Na other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterOrEquals(Na other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isLessThan(Na other) {
        return this.compareTo(other) < 0;
    }

    public Na shiftLeft(int n) {
        return new Na(this.value << n);
    }

    public Na shiftRight(int n) {
        return new Na(this.value >> n);
    }

    public int signum() {
        if (this.value == 0L) {
            return 0;
        }
        return this.value < 0L ? -1 : 1;
    }

    public Na negate() {
        return new Na(-this.value);
    }

    public String toText(int decimal) {
        BigInteger amount = BigInteger.valueOf(this.value).divide(BigInteger.TEN.pow(decimal));
        return amount.toString();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((Na)o).value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(Na other) {
        if (other == null) {
            return -1;
        }
        return Long.compare(this.value, other.value);
    }

    public static String naToNuls(Object object, int decimal) {
        if (null == object) {
            return "0";
        }
        Long na = null;
        if (object instanceof Long) {
            na = (Long)object;
        } else if (object instanceof Integer) {
            na = ((Integer)object).longValue();
        } else {
            if (object instanceof Double) {
                return String.valueOf(object);
            }
            if (object instanceof Float) {
                return String.valueOf(object);
            }
            if (object instanceof String) {
                try {
                    return Na.valueOf(Long.parseLong(object.toString())).toText(decimal);
                }
                catch (NumberFormatException e) {
                    Log.warn((String)"Number Format error, error object is [{}]", (Object[])new Object[]{object});
                    return "0";
                }
            }
            return "0";
        }
        return Na.valueOf(na).toText(decimal);
    }
}

