/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.filter;

import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.utils.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class RpcServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter,
ExceptionMapper<Exception> {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    public void filter(ContainerRequestContext requestContext) throws IOException {
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws UnsupportedEncodingException {
        this.response.setHeader("Access-control-Allow-Origin", this.request.getHeader("Origin"));
        this.response.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
        this.response.setHeader("Access-Control-Allow-Headers", this.request.getHeader("Access-Control-Request-Headers"));
        this.request.setCharacterEncoding("UTF-8");
        this.response.setCharacterEncoding("UTF-8");
    }

    public Response toResponse(Exception e) {
        RpcClientResult result;
        Log.error("RequestURI is " + this.request.getRequestURI(), e);
        if (e instanceof NulsException) {
            NulsException exception = (NulsException)((Object)e);
            result = new RpcClientResult(false, exception.getErrorCode());
        } else if (e instanceof NulsRuntimeException) {
            NulsRuntimeException exception = (NulsRuntimeException)e;
            result = RpcClientResult.getFailed(new ErrorData(exception.getCode(), exception.getMessage()));
        } else {
            result = RpcClientResult.getFailed(e.getMessage());
        }
        return Response.ok((Object)result, (String)"application/json").build();
    }
}

