/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc;

import io.nuls.core.exception.NulsException;
import io.nuls.core.log.Log;
import io.nuls.provider.api.jsonrpc.JsonRpcException;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.model.jsonrpc.RpcResultError;
import java.lang.reflect.Method;
import java.util.List;

public class RpcMethodInvoker {
    private Object bean;
    private Method method;

    public RpcMethodInvoker(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public RpcResult invoke(List<Object> jsonParams) {
        RpcResult result = null;
        try {
            result = (RpcResult)this.method.invoke(this.bean, jsonParams);
        }
        catch (Exception e) {
            Log.error((String)("\n" + this.method.toString()));
            if (e.getCause() instanceof JsonRpcException) {
                JsonRpcException jsonRpcException = (JsonRpcException)e.getCause();
                result = new RpcResult();
                result.setError(jsonRpcException.getError());
            }
            if (e.getCause() instanceof NulsException) {
                NulsException nulsException = (NulsException)e.getCause();
                result = new RpcResult();
                result.setError(new RpcResultError(nulsException.getErrorCode()));
            }
            Log.error((Throwable)e);
            result = new RpcResult();
            RpcResultError error = new RpcResultError();
            error.setMessage("system error");
            error.setCode("-32603");
            error.setData(e.getMessage());
            result.setError(error);
        }
        return result;
    }
}

