/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.account.AccountService;
import io.nuls.base.api.provider.account.facade.AccountInfo;
import io.nuls.base.api.provider.account.facade.CreateAccountReq;
import io.nuls.base.api.provider.account.facade.GetAccountPrivateKeyByAddressReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByKeyStoreReq;
import io.nuls.base.api.provider.account.facade.ImportAccountByPrivateKeyReq;
import io.nuls.base.api.provider.account.facade.KeyStoreReq;
import io.nuls.base.api.provider.account.facade.SetAccountAliasReq;
import io.nuls.base.api.provider.account.facade.UpdatePasswordReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.model.dto.AccountBlockDTO;
import io.nuls.provider.model.dto.AccountKeyStoreDto;
import io.nuls.provider.model.form.PriKeyForm;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.model.jsonrpc.RpcResultError;
import io.nuls.provider.rpctools.AccountTools;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.rpctools.LegderTools;
import io.nuls.provider.rpctools.vo.AccountBalance;
import io.nuls.provider.rpctools.vo.AccountBalanceWithDecimals;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.Utils;
import io.nuls.provider.utils.VerifyUtils;
import io.nuls.v2.SDKContext;
import io.nuls.v2.error.AccountErrorCode;
import io.nuls.v2.model.Account;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import io.nuls.v2.model.dto.AccountDto;
import io.nuls.v2.model.dto.AliasDto;
import io.nuls.v2.model.dto.MultiSignAliasDto;
import io.nuls.v2.model.dto.SignDto;
import io.nuls.v2.util.AccountTool;
import io.nuls.v2.util.NulsSDKTool;
import io.nuls.v2.util.ValidateUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Controller
@Api(type=ApiType.JSONRPC)
public class AccountController {
    @Autowired
    private ContractTools contractTools;
    @Autowired
    private LegderTools legderTools;
    @Autowired
    private AccountTools accountTools;
    @Autowired
    private Config config;
    AccountService accountService = (AccountService)ServiceManager.get(AccountService.class);
    private long time;

    @RpcMethod(value="createAccount")
    @ApiOperation(description="Batch Create Accounts", order=101, detailDesc="The created account exists in the local wallet")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Create quantity"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="password")})
    @ResponseData(name="Return value", description="Return account address set", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public RpcResult createAccount(List<Object> params) {
        String password;
        int count;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            count = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[count] is inValid");
        }
        try {
            password = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        CreateAccountReq req = new CreateAccountReq(count, password);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.createAccount(req);
        RpcResult<List> rpcResult = new RpcResult<List>();
        if (result.isFailed()) {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        } else {
            rpcResult.setResult(result.getList());
        }
        return rpcResult;
    }

    @RpcMethod(value="updatePassword")
    @ApiOperation(description="Change account password", order=102)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address"), @Parameter(parameterName="oldPassword", requestType=@TypeDescriptor(value=String.class), parameterDes="Original password"), @Parameter(parameterName="newPassword", requestType=@TypeDescriptor(value=String.class), parameterDes="New password")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Is the modification successful")}))
    public RpcResult updatePassword(List<Object> params) {
        String newPassword;
        String oldPassword;
        String address;
        int chainId;
        VerifyUtils.verifyParams(params, 4);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            oldPassword = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[oldPassword] is inValid");
        }
        try {
            newPassword = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[newPassword] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)oldPassword)) {
            return RpcResult.paramError("[oldPassword] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)newPassword)) {
            return RpcResult.paramError("[newPassword] is inValid");
        }
        if (Context.accessLimit && System.currentTimeMillis() - this.time < 3000L) {
            return RpcResult.paramError("Access frequency limit.");
        }
        this.time = System.currentTimeMillis();
        UpdatePasswordReq req = new UpdatePasswordReq(address, oldPassword, newPassword);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.updatePassword(req);
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isSuccess()) {
            rpcResult.setResult(result.getData());
        } else {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        return rpcResult;
    }

    @RpcMethod(value="getPriKey")
    @ApiOperation(description="Export account private key", order=103, detailDesc="Only the private key of an existing account in the local wallet can be exported")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterDes="Account address"), @Parameter(parameterName="password", parameterDes="password")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Private key")}))
    public RpcResult getPriKey(List<Object> params) {
        String password;
        String address;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            password = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (Context.accessLimit && System.currentTimeMillis() - this.time < 3000L) {
            return RpcResult.paramError("Access frequency limit.");
        }
        this.time = System.currentTimeMillis();
        GetAccountPrivateKeyByAddressReq req = new GetAccountPrivateKeyByAddressReq(password, address);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.getAccountPrivateKey(req);
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isSuccess()) {
            rpcResult.setResult(result.getData());
        } else {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        return rpcResult;
    }

    @RpcMethod(value="importPriKey")
    @ApiOperation(description="Import account based on private key", order=104, detailDesc="When importing a private key, you need to enter a password to encrypt the plaintext private key")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="priKey", requestType=@TypeDescriptor(value=String.class), parameterDes="Account plaintext private key"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="New password")})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcResult importPriKey(List<Object> params) {
        String password;
        String priKey;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            priKey = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        try {
            password = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (StringUtils.isBlank((String)priKey)) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        ImportAccountByPrivateKeyReq req = new ImportAccountByPrivateKeyReq(password, priKey, true);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.importAccountByPrivateKey(req);
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isSuccess()) {
            rpcResult.setResult(result.getData());
        } else {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        return rpcResult;
    }

    @RpcMethod(value="importKeystore")
    @ApiOperation(description="according tokeystoreImport account", order=105)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="keyStoreJson", requestType=@TypeDescriptor(value=Map.class), parameterDes="keyStoreJson"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="keystorepassword")})
    @ResponseData(name="Return value", description="Return account address", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcResult importKeystore(List<Object> params) {
        String password;
        String keyStoreJson;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            Map keyStoreMap = (Map)params.get(1);
            keyStoreJson = JSONUtils.obj2json((Object)keyStoreMap);
        }
        catch (Exception e) {
            return RpcResult.paramError("[keyStoreJson] is inValid");
        }
        try {
            password = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        ImportAccountByKeyStoreReq req = new ImportAccountByKeyStoreReq(password, HexUtil.encode((byte[])keyStoreJson.getBytes()), true);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.importAccountByKeyStore(req);
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isSuccess()) {
            rpcResult.setResult(result.getData());
        } else {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        return rpcResult;
    }

    @RpcMethod(value="exportKeystore")
    @ApiOperation(description="Account backup, exporting accountskeystoreinformation", order=106)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", description="returnkeystorecharacter string", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="result", description="keystore")}))
    public RpcResult exportKeystore(List<Object> params) {
        String password;
        String address;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            password = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (Context.accessLimit && System.currentTimeMillis() - this.time < 3000L) {
            return RpcResult.paramError("Access frequency limit.");
        }
        this.time = System.currentTimeMillis();
        KeyStoreReq req = new KeyStoreReq(password, address);
        req.setChainId(Integer.valueOf(chainId));
        io.nuls.base.api.provider.Result result = this.accountService.getAccountKeyStore(req);
        RpcResult<AccountKeyStoreDto> rpcResult = new RpcResult<AccountKeyStoreDto>();
        try {
            if (result.isSuccess()) {
                AccountKeyStoreDto keyStoreDto = (AccountKeyStoreDto)JSONUtils.json2pojo((String)((String)result.getData()), AccountKeyStoreDto.class);
                rpcResult.setResult(keyStoreDto);
            } else {
                rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
            }
            return rpcResult;
        }
        catch (IOException e) {
            return RpcResult.failed(CommonCodeConstanst.DATA_PARSE_ERROR);
        }
    }

    @RpcMethod(value="getAccountBalance")
    @ApiOperation(description="Query account balance", order=107, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnoncevalue")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="The chain of assetsID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalance.class))
    public RpcResult getAccountBalance(List<Object> params) {
        String address;
        int assetId;
        int assetChainId;
        int chainId;
        VerifyUtils.verifyParams(params, 4);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            assetChainId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetChainId] is inValid");
        }
        try {
            assetId = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is inValid");
        }
        try {
            address = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        RpcResult<AccountBalance> rpcResult = new RpcResult<AccountBalance>();
        io.nuls.base.api.provider.Result<AccountBalance> balanceResult = this.legderTools.getBalanceAndNonce(chainId, assetChainId, assetId, address);
        if (balanceResult.isFailed()) {
            return rpcResult.setError(new RpcResultError(balanceResult.getStatus(), balanceResult.getMessage(), null));
        }
        AccountBalance resultData = (AccountBalance)balanceResult.getData();
        if (resultData != null) {
            return rpcResult.setResult(resultData);
        }
        return rpcResult.setResult(null);
    }

    @RpcMethod(value="getAccountBalanceWithDecimals")
    @ApiOperation(description="Query account balance", order=107, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnoncevalue")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="assetChainId", requestType=@TypeDescriptor(value=int.class), parameterDes="The chain of assetsID"), @Parameter(parameterName="assetId", requestType=@TypeDescriptor(value=int.class), parameterDes="assetID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalanceWithDecimals.class))
    public RpcResult getAccountBalanceWithDecimals(List<Object> params) {
        String address;
        int assetId;
        int assetChainId;
        int chainId;
        VerifyUtils.verifyParams(params, 4);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            assetChainId = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetChainId] is inValid");
        }
        try {
            assetId = (Integer)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[assetId] is inValid");
        }
        try {
            address = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        io.nuls.base.api.provider.Result<AccountBalanceWithDecimals> balanceResult = this.legderTools.getBalanceAndNonceWithDecimals(chainId, assetChainId, assetId, address);
        if (balanceResult.isFailed()) {
            return rpcResult.setError(new RpcResultError(balanceResult.getStatus(), balanceResult.getMessage(), null));
        }
        return rpcResult.setResult(balanceResult.getData());
    }

    @RpcMethod(value="getBalanceList")
    @ApiOperation(description="Query account balance", order=107, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnonceValue set")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address"), @Parameter(parameterName="assetIdList", requestType=@TypeDescriptor(value=List.class), parameterDes="AssetsIDaggregate")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalance.class))
    public RpcResult getBalanceList(List<Object> params) {
        List coinDtoList;
        String address;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            coinDtoList = (List)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        RpcResult rpcResult = new RpcResult();
        io.nuls.base.api.provider.Result<List<AccountBalance>> balanceResult = this.legderTools.getBalanceList(chainId, coinDtoList, address);
        if (balanceResult.isFailed()) {
            return rpcResult.setError(new RpcResultError(balanceResult.getStatus(), balanceResult.getMessage(), null));
        }
        List list = (List)balanceResult.getData();
        if (list != null && !list.isEmpty()) {
            return rpcResult.setResult(list);
        }
        return rpcResult.setResult(Collections.emptyList());
    }

    @RpcMethod(value="getBalanceWithDecimalsList")
    @ApiOperation(description="Query account balance", order=107, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnonceValue set")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address"), @Parameter(parameterName="assetIdList", requestType=@TypeDescriptor(value=List.class), parameterDes="AssetsIDaggregate")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalance.class))
    public RpcResult getBalanceWithDecimalsList(List<Object> params) {
        List coinDtoList;
        String address;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            coinDtoList = (List)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        io.nuls.base.api.provider.Result<List<AccountBalanceWithDecimals>> balanceResult = this.legderTools.getBalanceWithDecimalsList(chainId, coinDtoList, address);
        if (balanceResult.isFailed()) {
            return rpcResult.setError(new RpcResultError(balanceResult.getStatus(), balanceResult.getMessage(), null));
        }
        return rpcResult.setResult(balanceResult.getData());
    }

    @RpcMethod(value="setAlias")
    @ApiOperation(description="Set account alias", order=108, detailDesc="The alias format is1-20A combination of lowercase letters and numbers, setting an alias will destroy it1individualNULS")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address"), @Parameter(parameterName="alias", requestType=@TypeDescriptor(value=String.class), parameterDes="alias"), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="Account password")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Setting up alias transactionshash")}))
    public RpcResult setAlias(List<Object> params) {
        String password;
        String alias;
        String address;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            alias = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[alias] is inValid");
        }
        try {
            password = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.dataNotFound();
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!FormatValidUtils.validAlias((String)alias)) {
            return RpcResult.paramError("[alias] is inValid");
        }
        if (StringUtils.isBlank((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        SetAccountAliasReq aliasReq = new SetAccountAliasReq(password, address, alias);
        io.nuls.base.api.provider.Result result = this.accountService.setAccountAlias(aliasReq);
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isSuccess()) {
            rpcResult.setResult(result.getData());
        } else {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        }
        return rpcResult;
    }

    @RpcMethod(value="validateAddress")
    @ApiOperation(description="Verify if the address is correct", order=109, detailDesc="Verify if the address is correct")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", requestType=@TypeDescriptor(value=String.class), parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="boolean")}))
    public RpcResult validateAddress(List<Object> params) {
        String address;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        boolean b = AddressTool.validAddress((int)chainId, (String)address);
        if (b) {
            return RpcResult.success(Map.of("value", true));
        }
        return RpcResult.failed(AccountErrorCode.ADDRESS_ERROR);
    }

    @RpcMethod(value="getAddressByPublicKey")
    @ApiOperation(description="Generate account address based on account public key", order=110, detailDesc="Generate account address based on account public key")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="publicKey", requestType=@TypeDescriptor(value=String.class), parameterDes="Account public key")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Account address")}))
    public RpcResult getAddressByPublicKey(List<Object> params) {
        String publicKey;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            publicKey = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[publicKey] is inValid");
        }
        try {
            byte[] address = AddressTool.getAddress((byte[])HexUtil.decode((String)publicKey), (int)chainId);
            return RpcResult.success(Map.of("address", AddressTool.getStringAddressByBytes((byte[])address)));
        }
        catch (Exception e) {
            Log.error(e);
            return RpcResult.failed(AccountErrorCode.ADDRESS_ERROR);
        }
    }

    @RpcMethod(value="createAccountOffline")
    @ApiOperation(description="off-line - Batch Create Accounts", order=151, detailDesc="The created account will not be saved to the wallet,The interface directly returns the account'skeystoreinformation")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Create quantity"), @Parameter(parameterName="prefix", requestType=@TypeDescriptor(value=String.class), parameterDes="Address prefix", canNull=true), @Parameter(parameterName="password", requestType=@TypeDescriptor(value=String.class), parameterDes="password")})
    @ResponseData(name="Return value", description="Return account information collection", responseType=@TypeDescriptor(value=List.class, collectionElement=AccountDto.class))
    public RpcResult createAccountOffline(List<Object> params) {
        String password;
        String prefix;
        int count;
        int chainId;
        VerifyUtils.verifyParams(params, 3);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            count = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[count] is inValid");
        }
        try {
            prefix = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[prefix] is inValid");
        }
        try {
            password = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (!FormatValidUtils.validPassword((String)password)) {
            return RpcResult.paramError("[password] is inValid");
        }
        Result result = StringUtils.isBlank((String)prefix) ? NulsSDKTool.createOffLineAccount((int)count, (String)password) : NulsSDKTool.createOffLineAccount((int)chainId, (int)count, (String)prefix, (String)password);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getPriKeyOffline")
    @ApiOperation(description="Offline acquisition of account plaintext private key", order=152)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="encryptedPrivateKey", parameterType="String", parameterDes="Account ciphertext private key"), @Parameter(parameterName="password", parameterType="String", parameterDes="password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Clear text private key")}))
    public RpcResult getPriKeyOffline(List<Object> params) {
        String password;
        String encryptedPriKey;
        String address;
        try {
            int chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            encryptedPriKey = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[encryptedPriKey] is inValid");
        }
        try {
            password = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        Result result = NulsSDKTool.getPriKeyOffline((String)address, (String)encryptedPriKey, (String)password);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="resetPasswordOffline")
    @ApiOperation(description="Offline account password modification", order=153)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="encryptedPrivateKey", parameterType="String", parameterDes="Account ciphertext private key"), @Parameter(parameterName="oldPassword", parameterType="String", parameterDes="Original password"), @Parameter(parameterName="newPassword", parameterType="String", parameterDes="New password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Encryption private key after resetting password")}))
    public RpcResult resetPasswordOffline(List<Object> params) {
        String newPassword;
        String oldPassword;
        String encryptedPriKey;
        String address;
        try {
            int chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            encryptedPriKey = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[encryptedPriKey] is inValid");
        }
        try {
            oldPassword = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[oldPassword] is inValid");
        }
        try {
            newPassword = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[newPassword] is inValid");
        }
        Result result = NulsSDKTool.resetPasswordOffline((String)address, (String)encryptedPriKey, (String)oldPassword, (String)newPassword);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="multiSign")
    @ApiOperation(description="Multiple Account Summary Signature", order=154, detailDesc="Multi account transfer transaction for offline assembly of signatures,When calling the interface, parameters can be passed an address and private key, or an address and encryption private key and encryption password")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="signDtoList", parameterDes="Summary signature form", requestType=@TypeDescriptor(value=List.class, collectionElement=SignDto.class)), @Parameter(parameterName="txHex", parameterType="String", parameterDes="Transaction serialization16Hexadecimal Strings")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcResult multiSign(List<Object> params) {
        int chainId;
        ArrayList<SignDto> signDtoList = new ArrayList<SignDto>();
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        try {
            List signMap = (List)params.get(1);
            for (Map map : signMap) {
                SignDto signDto = (SignDto)JSONUtils.map2pojo((Map)map, SignDto.class);
                signDtoList.add(signDto);
            }
        }
        catch (Exception e) {
            return RpcResult.paramError("[signDto] is inValid");
        }
        String txHex = (String)params.get(2);
        Result result = NulsSDKTool.sign(signDtoList, (String)txHex);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="priKeySign")
    @ApiOperation(description="Clear text private key digest signature", order=155)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="txHex", parameterType="String", parameterDes="Transaction serialization16Hexadecimal Strings"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="privateKey", parameterType="String", parameterDes="Account plaintext private key")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcResult sign(List<Object> params) {
        String priKey;
        String address;
        String txHex;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        try {
            address = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            priKey = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        if (StringUtils.isBlank((String)txHex)) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (StringUtils.isBlank((String)priKey)) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        Result result = NulsSDKTool.sign((String)txHex, (String)address, (String)priKey);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="isBlockAccount")
    @ApiOperation(description="Is the account locked", order=165)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Is it locked")}))
    public RpcResult isBlockAccount(List<Object> params) {
        String address;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        boolean blockAccount = this.accountTools.isBlockAccount(chainId, address);
        return RpcResult.success(Map.of("value", blockAccount));
    }

    @RpcMethod(value="getBlockAccountInfo")
    @ApiOperation(description="Query locked account information", order=166)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=AccountBlockDTO.class))
    public RpcResult getBlockAccountInfo(List<Object> params) {
        String address;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            address = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        AccountBlockDTO dto = this.accountTools.getBlockAccountInfo(chainId, address);
        if (dto == null) {
            return RpcResult.failed(AccountErrorCode.DATA_NOT_FOUND);
        }
        return RpcResult.success(dto);
    }

    @RpcMethod(value="getAllContractCallAccount")
    @ApiOperation(description="Query the whitelist of accounts that allow regular transfers when calling contracts", order=167)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=AccountBlockDTO.class))
    public RpcResult getAllContractCallAccount(List<Object> params) {
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Map map = this.accountTools.getAllContractCallAccount(chainId);
        if (map == null) {
            return RpcResult.failed(AccountErrorCode.DATA_NOT_FOUND);
        }
        return RpcResult.success(map);
    }

    @RpcMethod(value="encryptedPriKeySign")
    @ApiOperation(description="Cryptography private key digest signature", order=156)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="txHex", parameterType="String", parameterDes="Transaction serialization16Hexadecimal Strings"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="encryptedPrivateKey", parameterType="String", parameterDes="Account ciphertext private key"), @Parameter(parameterName="password", parameterType="String", parameterDes="password")})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Signed transaction16Hexadecimal Strings")}))
    public RpcResult encryptedPriKeySign(List<Object> params) {
        String password;
        String encryptedPriKey;
        String address;
        String txHex;
        int chainId;
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        try {
            txHex = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        try {
            address = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            encryptedPriKey = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[encryptedPriKey] is inValid");
        }
        try {
            password = (String)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[password] is inValid");
        }
        if (StringUtils.isBlank((String)txHex)) {
            return RpcResult.paramError("[txHex] is inValid");
        }
        if (!AddressTool.validAddress((int)chainId, (String)address)) {
            return RpcResult.paramError("[address] is inValid");
        }
        if (StringUtils.isBlank((String)encryptedPriKey)) {
            return RpcResult.paramError("[encryptedPriKey] is inValid");
        }
        Result result = NulsSDKTool.sign((String)txHex, (String)address, (String)encryptedPriKey, (String)password);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="createMultiSignAccount")
    @ApiOperation(description="Create a multi signature account", order=157, detailDesc="Create multiple signed accounts based on the public keys of multiple accounts,minSignsThe minimum number of signatures required to create transactions for multi signature accounts")
    @Parameters(value={@Parameter(parameterName="pubKeys", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Account public key collection"), @Parameter(parameterName="minSigns", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum number of signatures")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="The address of the account")}))
    public RpcResult createMultiSignAccount(List<Object> params) {
        int minSigns;
        List pubKeys;
        VerifyUtils.verifyParams(params, 2);
        try {
            pubKeys = (List)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[pubKeys] is inValid");
        }
        try {
            minSigns = (Integer)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[minSigns] is inValid");
        }
        if (pubKeys.isEmpty()) {
            return RpcResult.paramError("[pubKeys] is empty");
        }
        if (minSigns < 1 || minSigns > pubKeys.size()) {
            return RpcResult.paramError("[minSigns] is inValid");
        }
        Result result = NulsSDKTool.createMultiSignAccount((List)pubKeys, (int)minSigns);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="createAliasTx")
    @ApiOperation(description="Offline creation and setting of alias transactions", order=158)
    @Parameters(value={@Parameter(parameterName="Create an alias transaction", parameterDes="Create an alias transaction form", requestType=@TypeDescriptor(value=AliasDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcResult createAliasTx(List<Object> params) {
        String nonce;
        String alias;
        String address;
        VerifyUtils.verifyParams(params, 3);
        try {
            address = (String)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            alias = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[alias] is inValid");
        }
        try {
            nonce = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[nonce] is inValid");
        }
        AliasDto dto = new AliasDto();
        dto.setAddress(address);
        dto.setAlias(alias);
        dto.setNonce(nonce);
        Result result = NulsSDKTool.createAliasTxOffline((AliasDto)dto);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="createMultiSignAliasTx")
    @ApiOperation(description="Offline creation and setting of alias transactions for multiple signed accounts", order=159)
    @Parameters(value={@Parameter(parameterName="Offline creation and setting of alias transactions for multiple signed accounts", parameterDes="Create an alias transaction form", requestType=@TypeDescriptor(value=MultiSignAliasDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcResult createMultiSignAliasTx(List<Object> params) {
        int minSigns;
        List pubKeys;
        String remark;
        String nonce;
        String alias;
        String address;
        try {
            address = (String)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[address] is inValid");
        }
        try {
            alias = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[alias] is inValid");
        }
        try {
            nonce = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[nonce] is inValid");
        }
        try {
            remark = (String)params.get(3);
        }
        catch (Exception e) {
            return RpcResult.paramError("[remark] is inValid");
        }
        try {
            pubKeys = (List)params.get(4);
        }
        catch (Exception e) {
            return RpcResult.paramError("[pubKeys] is inValid");
        }
        try {
            minSigns = (Integer)params.get(5);
        }
        catch (Exception e) {
            return RpcResult.paramError("[minSigns] is inValid");
        }
        MultiSignAliasDto dto = new MultiSignAliasDto();
        dto.setAddress(address);
        dto.setAlias(alias);
        dto.setNonce(nonce);
        dto.setPubKeys(pubKeys);
        dto.setMinSigns(minSigns);
        dto.setRemark(remark);
        Result result = NulsSDKTool.createMultiSignAliasTxOffline((MultiSignAliasDto)dto);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getAddressByPriKey")
    @ApiOperation(description="Obtain account address format based on private key", order=160)
    @Parameters(value={@Parameter(parameterName="Original private key", parameterDes="Private Key Form", requestType=@TypeDescriptor(value=PriKeyForm.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Account address")}))
    public RpcResult getAddressByPriKey(List<Object> params) {
        try {
            String priKey = (String)params.get(0);
            Result result = NulsSDKTool.getAddressByPriKey((String)priKey);
            return ResultUtil.getJsonRpcResult(result);
        }
        catch (Exception e) {
            return RpcResult.paramError("[priKey] is inValid");
        }
    }

    @RpcMethod(value="getAddressList")
    @ApiOperation(description="Query the list of accounts created in the wallet", order=161)
    public RpcResult getAddressList(List<Object> params) {
        io.nuls.base.api.provider.Result result = this.accountService.getAccountList();
        if (result.isSuccess()) {
            ArrayList<String> addressList = new ArrayList<String>();
            for (Object o : result.getList()) {
                AccountInfo acc = (AccountInfo)o;
                addressList.add(acc.getAddress());
            }
            result.setList(addressList);
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="signMessage")
    @ApiOperation(description="Clear text private key digest signature message", order=162)
    @Parameters(value={@Parameter(parameterName="message", parameterType="String", parameterDes="news"), @Parameter(parameterName="privateKey", parameterType="String", parameterDes="Private key")})
    @ResponseData(name="signedMessage", description="Message signature")
    public RpcResult signMessage(List<Object> params) {
        String priKey;
        String message;
        try {
            message = (String)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[message] is inValid");
        }
        try {
            priKey = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        if (StringUtils.isBlank((String)message)) {
            return RpcResult.paramError("[message] is inValid");
        }
        if (StringUtils.isBlank((String)priKey)) {
            return RpcResult.paramError("[priKey] is inValid");
        }
        ECKey ecKey = ECKey.fromPrivate((BigInteger)new BigInteger(1, HexUtil.decode((String)priKey)));
        byte[] signbytes = ecKey.sign(Utils.dataToBytes(message));
        return RpcResult.success(HexUtil.encode((byte[])signbytes));
    }

    @RpcMethod(value="verifySignedMessage")
    @ApiOperation(description="Verify message signature", order=163)
    @Parameters(value={@Parameter(parameterName="message", parameterType="String", parameterDes="news"), @Parameter(parameterName="signature", parameterType="String", parameterDes="Message signature"), @Parameter(parameterName="publicKey", parameterType="String", parameterDes="Public key")})
    @ResponseData(description="Verify if successful", responseType=@TypeDescriptor(value=Boolean.class))
    public RpcResult verifySignedMessage(List<Object> params) {
        String publicKey;
        String signature;
        String message;
        try {
            message = (String)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[message] is inValid");
        }
        try {
            signature = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[signature] is inValid");
        }
        try {
            publicKey = (String)params.get(2);
        }
        catch (Exception e) {
            return RpcResult.paramError("[publicKey] is inValid");
        }
        if (StringUtils.isBlank((String)message)) {
            return RpcResult.paramError("[message] is inValid");
        }
        if (StringUtils.isBlank((String)signature)) {
            return RpcResult.paramError("[signature] is inValid");
        }
        if (StringUtils.isBlank((String)publicKey)) {
            return RpcResult.paramError("[publicKey] is inValid");
        }
        boolean verify = ECKey.verify((byte[])Utils.dataToBytes(message), (byte[])HexUtil.decode((String)signature), (byte[])HexUtil.decode((String)publicKey));
        return RpcResult.success(verify);
    }

    @RpcMethod(value="getPubKeyByPriKey")
    @ApiOperation(description="Obtain public key based on private key", order=164)
    @Parameters(value={@Parameter(parameterName="Original private key", parameterDes="Private Key Form", requestType=@TypeDescriptor(value=PriKeyForm.class))})
    @ResponseData(name="Return value", description="Public keyHEXEncoding string")
    public RpcResult getPubKeyByPriKey(List<Object> params) {
        try {
            Account account;
            String priKey = (String)params.get(0);
            ValidateUtil.validateChainId();
            if (!ECKey.isValidPrivteHex((String)priKey)) {
                throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            try {
                account = StringUtils.isBlank((String)SDKContext.addressPrefix) ? AccountTool.createAccount((int)SDKContext.main_chain_id, (String)priKey) : AccountTool.createAccount((int)SDKContext.main_chain_id, (String)priKey, (String)SDKContext.addressPrefix);
            }
            catch (NulsException e) {
                throw new NulsRuntimeException(AccountErrorCode.PRIVATE_KEY_WRONG);
            }
            return RpcResult.success(HexUtil.encode((byte[])account.getPubKey()));
        }
        catch (Exception e) {
            return RpcResult.paramError("[priKey] is inValid");
        }
    }
}

