/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHashReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByHeightReq;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.base.data.Block;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.exception.NulsException;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.api.config.Context;
import io.nuls.provider.api.manager.BeanCopierManager;
import io.nuls.provider.model.dto.block.BlockDto;
import io.nuls.provider.model.dto.block.BlockHeaderDto;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.rpctools.BlockTools;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.VerifyUtils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import io.nuls.v2.util.ValidateUtil;
import java.util.List;

@Controller
@Api(type=ApiType.JSONRPC)
public class BlockController {
    BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);
    @Autowired
    private Config config;
    @Autowired
    BlockTools blockTools;

    @RpcMethod(value="getHeaderByHeight")
    @ApiOperation(description="Query block headers based on block height", order=201)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcResult getHeaderByHeight(List<Object> params) {
        long height;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        try {
            height = Long.parseLong("" + params.get(1));
        }
        catch (Exception e) {
            return RpcResult.paramError("[height] is invalid");
        }
        if (height < 0L) {
            return RpcResult.paramError("[height] is invalid");
        }
        GetBlockHeaderByHeightReq req = new GetBlockHeaderByHeightReq(Long.valueOf(height));
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByHeight(req);
        if (result.isSuccess() && result.getData() != null) {
            BlockHeaderData data = (BlockHeaderData)result.getData();
            BlockHeaderDto dto = new BlockHeaderDto();
            BeanCopierManager.beanCopier(data, dto);
            return RpcResult.success(dto);
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getHeaderByHash")
    @ApiOperation(description="Based on blockshashQuery block header", order=202)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcResult getHeaderByHash(List<Object> params) {
        String hash;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        try {
            hash = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[hash] is invalid");
        }
        if (!ValidateUtil.validHash((String)hash)) {
            return RpcResult.paramError("[hash] is required");
        }
        GetBlockHeaderByHashReq req = new GetBlockHeaderByHashReq(hash);
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByHash(req);
        if (result.isSuccess() && result.getData() != null) {
            BlockHeaderData data = (BlockHeaderData)result.getData();
            BlockHeaderDto dto = new BlockHeaderDto();
            BeanCopierManager.beanCopier(data, dto);
            return RpcResult.success(dto);
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBestBlockHeader")
    @ApiOperation(description="Query the latest block header information", order=203)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockHeaderDto.class))
    public RpcResult getBestBlockHeader(List<Object> params) {
        int chainId;
        VerifyUtils.verifyParams(params, 1);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        GetBlockHeaderByLastHeightReq req = new GetBlockHeaderByLastHeightReq();
        req.setChainId(this.config.getChainId());
        Result result = this.blockService.getBlockHeaderByLastHeight(req);
        if (result.isSuccess()) {
            BlockHeaderData data = (BlockHeaderData)result.getData();
            BlockHeaderDto dto = new BlockHeaderDto();
            BeanCopierManager.beanCopier(data, dto);
            return RpcResult.success(dto);
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBestBlock")
    @ApiOperation(description="Query the latest block", order=204, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcResult getBestBlock(List<Object> params) {
        int chainId;
        VerifyUtils.verifyParams(params, 1);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is inValid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<Block> result = this.blockTools.getBestBlock(Context.getChainId());
        if (result.isSuccess() && result.getData() != null) {
            Block data = (Block)result.getData();
            try {
                BlockDto dto = new BlockDto(data);
                BeanCopierManager.beanCopier(data, dto);
                return RpcResult.success(dto);
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionJsonRpcResult(e);
            }
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBlockByHeight")
    @ApiOperation(description="Query blocks based on block height", order=205, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcResult getBlockByHeight(List<Object> params) {
        long height;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        try {
            height = Long.parseLong("" + params.get(1));
        }
        catch (Exception e) {
            return RpcResult.paramError("[height] is invalid");
        }
        if (height < 0L) {
            return RpcResult.paramError("[height] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<Block> result = this.blockTools.getBlockByHeight(chainId, height);
        if (result.isSuccess() && result.getData() != null) {
            Block data = (Block)result.getData();
            try {
                BlockDto dto = new BlockDto(data);
                return RpcResult.success(dto);
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionJsonRpcResult(e);
            }
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBlockByHash")
    @ApiOperation(description="Based on blockshashQuery Block", order=206, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=BlockDto.class))
    public RpcResult getBlockByHash(List<Object> params) {
        String hash;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        try {
            hash = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[hash] is invalid");
        }
        if (!ValidateUtil.validHash((String)hash)) {
            return RpcResult.paramError("[hash] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<Block> result = this.blockTools.getBlockByHash(chainId, hash);
        if (result.isSuccess() && result.getData() != null) {
            Block data = (Block)result.getData();
            try {
                BlockDto dto = new BlockDto(data);
                return RpcResult.success(dto);
            }
            catch (NulsException e) {
                Log.error(e);
                return ResultUtil.getNulsExceptionJsonRpcResult(e);
            }
        }
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBlockSerializationByHeight")
    @ApiOperation(description="Query block serialization strings based on block height", order=207, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="height", requestType=@TypeDescriptor(value=long.class), parameterDes="block height")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public RpcResult getBlockSerializationByHeight(List<Object> params) {
        long height;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        try {
            height = Long.parseLong("" + params.get(1));
        }
        catch (Exception e) {
            return RpcResult.paramError("[height] is invalid");
        }
        if (height < 0L) {
            return RpcResult.paramError("[height] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<String> result = this.blockTools.getBlockSerializationByHeight(chainId, height);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getBlockSerializationByHash")
    @ApiOperation(description="Based on blockshashQuery block serialization string", order=208, detailDesc="This interface contains all transaction information packaged in blocks. It returns a large amount of data and should be called with caution")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID"), @Parameter(parameterName="hash", parameterDes="blockhash")})
    @ResponseData(name="Return value", description="Return the serialized blockHEXcharacter string", responseType=@TypeDescriptor(value=String.class))
    public RpcResult getBlockSerializationByHash(List<Object> params) {
        String hash;
        int chainId;
        VerifyUtils.verifyParams(params, 2);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        try {
            hash = (String)params.get(1);
        }
        catch (Exception e) {
            return RpcResult.paramError("[hash] is invalid");
        }
        if (!ValidateUtil.validHash((String)hash)) {
            return RpcResult.paramError("[hash] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<String> result = this.blockTools.getBlockSerializationByHash(chainId, hash);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="getLatestHeight")
    @ApiOperation(description="Get the latest main chain height", order=209)
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainID")})
    @ResponseData(name="Return value", description="Get the latest main chain height", responseType=@TypeDescriptor(value=Long.class))
    public RpcResult getLatestHeight(List<Object> params) {
        int chainId;
        VerifyUtils.verifyParams(params, 1);
        try {
            chainId = (Integer)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[chainId] is invalid");
        }
        if (!Context.isChainExist(chainId)) {
            return RpcResult.paramError(String.format("chainId [%s] is invalid", chainId));
        }
        Result<String> result = this.blockTools.latestHeight(chainId);
        return ResultUtil.getJsonRpcResult(result);
    }

    @RpcMethod(value="testGetBlock")
    public RpcResult testGetBlock(List<Object> params) {
        while (true) {
            Result<Block> result;
            if ((result = this.blockTools.getBestBlock(1)).isFailed()) {
                System.out.println(result.getStatus());
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

