/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.block.BlockService;
import io.nuls.base.api.provider.block.facade.BlockHeaderData;
import io.nuls.base.api.provider.block.facade.GetBlockHeaderByLastHeightReq;
import io.nuls.base.api.provider.crosschain.CrossChainProvider;
import io.nuls.base.api.provider.crosschain.facade.RehandleCtxReq;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.model.jsonrpc.RpcErrorCode;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.utils.VerifyUtils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import java.util.List;

@Controller
@Api(type=ApiType.JSONRPC)
public class CrossChainController {
    private BlockService blockService = (BlockService)ServiceManager.get(BlockService.class);
    private CrossChainProvider crossChainProvider = (CrossChainProvider)ServiceManager.get(CrossChainProvider.class);

    public CrossChainController() {
        System.out.println();
    }

    @RpcMethod(value="rehandlectx")
    @ApiOperation(description="Resend transactions that have already been held by the cardholder", order=901, detailDesc="Resending only represents the attempt of this node and cannot guarantee the final result")
    @Parameters(value={@Parameter(parameterName="hash", requestType=@TypeDescriptor(value=String.class), parameterDes="Cross chain transactionshash")})
    @ResponseData(name="Return value", description="Whether successful", responseType=@TypeDescriptor(value=Boolean.class))
    public RpcResult createAccount(List<Object> params) {
        String hash;
        VerifyUtils.verifyParams(params, 1);
        try {
            hash = (String)params.get(0);
        }
        catch (Exception e) {
            return RpcResult.paramError("[hash] is inValid");
        }
        long blockHeight = ((BlockHeaderData)this.blockService.getBlockHeaderByLastHeight(new GetBlockHeaderByLastHeightReq()).getData()).getHeight();
        Result result = this.crossChainProvider.rehandleCtx(new RehandleCtxReq(hash, blockHeight));
        if (result.isFailed()) {
            return RpcResult.failed(RpcErrorCode.SYS_UNKNOWN_EXCEPTION);
        }
        return RpcResult.success(true);
    }
}

