/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.jsonrpc.controller;

import io.nuls.base.api.provider.Result;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.network.NetworkProvider;
import io.nuls.base.api.provider.network.facade.NetworkInfo;
import io.nuls.core.core.annotation.Controller;
import io.nuls.core.core.annotation.RpcMethod;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.model.jsonrpc.RpcResult;
import io.nuls.provider.model.jsonrpc.RpcResultError;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.annotation.ApiType;
import java.util.List;

@Controller
@Api(type=ApiType.JSONRPC)
public class NetworkController {
    private NetworkProvider networkProvider = (NetworkProvider)ServiceManager.get(NetworkProvider.class);

    @RpcMethod(value="getNetworkInfo")
    @ApiOperation(description="Obtain network status information for this node", order=201)
    @ResponseData(name="Return value", description="Return to network status", responseType=@TypeDescriptor(value=NetworkInfo.class, mapKeys={@Key(name="localBestHeight", description="Local height"), @Key(name="netBestHeight", description="Network height"), @Key(name="timeOffset", description="Time offset value"), @Key(name="inCount", description="Number of access nodes"), @Key(name="outCount", description="Number of connected nodes")}))
    public RpcResult getVersion(List<Object> params) {
        Result result = this.networkProvider.getInfo();
        RpcResult<Object> rpcResult = new RpcResult<Object>();
        if (result.isFailed()) {
            rpcResult.setError(new RpcResultError(result.getStatus(), result.getMessage(), null));
        } else {
            rpcResult.setResult(result.getData());
        }
        return rpcResult;
    }
}

