/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.RPCUtil;
import io.nuls.base.api.provider.ServiceManager;
import io.nuls.base.api.provider.crosschain.CrossChainProvider;
import io.nuls.base.api.provider.crosschain.facade.CreateCrossTxReq;
import io.nuls.base.api.provider.ledger.LedgerProvider;
import io.nuls.base.api.provider.transaction.TransferService;
import io.nuls.base.api.provider.transaction.facade.TransferReq;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Transaction;
import io.nuls.core.basic.Result;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.model.ErrorData;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.model.dto.AccountBalanceDto;
import io.nuls.provider.model.dto.AccountBalanceWithDecimalsDto;
import io.nuls.provider.model.form.BalanceForm;
import io.nuls.provider.model.form.CrossTransferForm;
import io.nuls.provider.model.form.TransferForm;
import io.nuls.provider.model.form.TxForm;
import io.nuls.provider.rpctools.ContractTools;
import io.nuls.provider.rpctools.LegderTools;
import io.nuls.provider.rpctools.TransactionTools;
import io.nuls.provider.rpctools.vo.AccountBalance;
import io.nuls.provider.rpctools.vo.AccountBalanceWithDecimals;
import io.nuls.provider.utils.Log;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.provider.utils.Utils;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import io.nuls.v2.model.dto.CrossTransferTxFeeDto;
import io.nuls.v2.model.dto.MultiSignTransferDto;
import io.nuls.v2.model.dto.MultiSignTransferTxFeeDto;
import io.nuls.v2.model.dto.TransferDto;
import io.nuls.v2.model.dto.TransferTxFeeDto;
import io.nuls.v2.txdata.CallContractData;
import io.nuls.v2.txdata.CreateContractData;
import io.nuls.v2.txdata.DeleteContractData;
import io.nuls.v2.util.CommonValidator;
import io.nuls.v2.util.NulsSDKTool;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/api/accountledger")
@Component
@Api
public class AccountLedgerResource {
    @Autowired
    Config config;
    TransferService transferService = (TransferService)ServiceManager.get(TransferService.class);
    CrossChainProvider crossChainProvider = (CrossChainProvider)ServiceManager.get(CrossChainProvider.class);
    LedgerProvider ledgerProvider = (LedgerProvider)ServiceManager.get(LedgerProvider.class);
    @Autowired
    TransactionTools transactionTools;
    @Autowired
    private ContractTools contractTools;
    @Autowired
    private LegderTools legderTools;

    @POST
    @Path(value="/balance/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query account balance", order=109, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnoncevalue")
    @Parameters(value={@Parameter(parameterName="balanceDto", parameterDes="Account Balance Form", requestType=@TypeDescriptor(value=BalanceForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalanceDto.class))
    public RpcClientResult getBalance(@PathParam(value="address") String address, BalanceForm form) {
        if (!AddressTool.validAddress((int)this.config.getChainId(), (String)address)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is invalid"));
        }
        if (form.getAssetChainId() < 1 || form.getAssetChainId() > 65535) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "assetChainId is invalid"));
        }
        if (form.getAssetId() < 1 || form.getAssetId() > 65535) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "assetId is invalid"));
        }
        io.nuls.base.api.provider.Result<AccountBalance> balanceResult = this.legderTools.getBalanceAndNonce(this.config.getChainId(), form.getAssetChainId(), form.getAssetId(), address);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(balanceResult);
        if (clientResult.isSuccess()) {
            clientResult.setData(new AccountBalanceDto((AccountBalance)clientResult.getData()));
        }
        return clientResult;
    }

    @POST
    @Path(value="/balanceWithDecimals/{address}")
    @Produces(value={"application/json"})
    @ApiOperation(description="Query account balance", order=109, detailDesc="According to the asset chainIDAnd assetsID, query the balance of assets corresponding to this chain account andnoncevalue")
    @Parameters(value={@Parameter(parameterName="balanceDto", parameterDes="Account Balance Form", requestType=@TypeDescriptor(value=BalanceForm.class))})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=AccountBalanceWithDecimalsDto.class))
    public RpcClientResult getBalanceWithDecimals(@PathParam(value="address") String address, BalanceForm form) {
        if (!AddressTool.validAddress((int)this.config.getChainId(), (String)address)) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "address is invalid"));
        }
        if (form.getAssetChainId() < 1 || form.getAssetChainId() > 65535) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "assetChainId is invalid"));
        }
        if (form.getAssetId() < 1 || form.getAssetId() > 65535) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "assetId is invalid"));
        }
        io.nuls.base.api.provider.Result<AccountBalanceWithDecimals> balanceResult = this.legderTools.getBalanceAndNonceWithDecimals(this.config.getChainId(), form.getAssetChainId(), form.getAssetId(), address);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(balanceResult);
        if (clientResult.isSuccess()) {
            clientResult.setData(new AccountBalanceWithDecimalsDto((AccountBalanceWithDecimals)clientResult.getData()));
        }
        return clientResult;
    }

    @POST
    @Path(value="/transaction/validate")
    @Produces(value={"application/json"})
    @ApiOperation(description="Verify transactions", order=302, detailDesc="Verify transactions for offline assembly,Successful verification returns transactionhashvalue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="Verify if the transaction is correct", parameterDes="Verify the correctness of the transaction form", requestType=@TypeDescriptor(value=TxForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult validate(TxForm form) {
        if (form == null || StringUtils.isBlank((String)form.getTxHex())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        io.nuls.base.api.provider.Result result = this.transactionTools.validateTx(this.config.getChainId(), form.getTxHex());
        return ResultUtil.getRpcClientResult(result);
    }

    @POST
    @Path(value="/transaction/broadcast")
    @Produces(value={"application/json"})
    @ApiOperation(description="Broadcasting transactions", order=303, detailDesc="Broadcast offline assembly transactions,Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="Broadcasting transactions", parameterDes="Broadcast transaction form", requestType=@TypeDescriptor(value=TxForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcClientResult broadcast(TxForm form) {
        if (form == null || StringUtils.isBlank((String)form.getTxHex())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            Map contractMap;
            String txHex = form.getTxHex();
            int type = Utils.extractTxTypeFromTx(txHex);
            io.nuls.base.api.provider.Result<Map> result = null;
            switch (type) {
                case 15: {
                    Transaction tx = new Transaction();
                    tx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    CreateContractData create = new CreateContractData();
                    create.parse(new NulsByteBuffer(tx.getTxData()));
                    RpcClientResult createArgsResult = this.validateContractArgs(create.getArgs());
                    if (createArgsResult.isFailed()) {
                        return createArgsResult;
                    }
                    result = this.contractTools.validateContractCreate(this.config.getChainId(), AddressTool.getStringAddressByBytes((byte[])create.getSender()), create.getGasLimit(), create.getPrice(), RPCUtil.encode((byte[])create.getCode()), create.getArgs());
                    break;
                }
                case 16: {
                    Transaction callTx = new Transaction();
                    callTx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    CallContractData call = new CallContractData();
                    call.parse(new NulsByteBuffer(callTx.getTxData()));
                    RpcClientResult argsResult = this.validateContractArgs(call.getArgs());
                    if (argsResult.isFailed()) {
                        return argsResult;
                    }
                    String[][] multyAssetValues = Utils.extractMultyAssetInfoFromCallTransaction(call.getContractAddress(), callTx.getCoinDataInstance(), this.config.getChainId(), this.config.getAssetsId());
                    result = this.contractTools.validateContractCall(this.config.getChainId(), AddressTool.getStringAddressByBytes((byte[])call.getSender()), call.getValue(), call.getGasLimit(), call.getPrice(), AddressTool.getStringAddressByBytes((byte[])call.getContractAddress()), call.getMethodName(), call.getMethodDesc(), call.getArgs(), multyAssetValues);
                    break;
                }
                case 17: {
                    Transaction deleteTx = new Transaction();
                    deleteTx.parse(new NulsByteBuffer(RPCUtil.decode((String)txHex)));
                    DeleteContractData delete = new DeleteContractData();
                    delete.parse(new NulsByteBuffer(deleteTx.getTxData()));
                    result = this.contractTools.validateContractDelete(this.config.getChainId(), AddressTool.getStringAddressByBytes((byte[])delete.getSender()), AddressTool.getStringAddressByBytes((byte[])delete.getContractAddress()));
                    break;
                }
            }
            if (result != null && (contractMap = (Map)result.getData()) != null && Boolean.FALSE.equals(contractMap.get("success"))) {
                return RpcClientResult.getFailed((String)contractMap.get("msg"));
            }
            result = this.transactionTools.newTx(this.config.getChainId(), txHex);
            return ResultUtil.getRpcClientResult((io.nuls.base.api.provider.Result)result);
        }
        catch (Exception e) {
            Log.error(e);
            return RpcClientResult.getFailed(e.getMessage());
        }
    }

    private RpcClientResult validateContractArgs(String[][] args) {
        if (args == null || args.length == 0) {
            return RpcClientResult.getSuccess(null);
        }
        try {
            for (String[] arg : args) {
                if (arg == null || arg.length == 0) continue;
                for (String str : arg) {
                    if (this.checkSpaceArg(str)) continue;
                    return RpcClientResult.getFailed("Illegal space character");
                }
            }
            return RpcClientResult.getSuccess(null);
        }
        catch (Exception e) {
            Log.error("parse args error.", e);
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.DATA_PARSE_ERROR));
        }
    }

    private boolean checkSpaceArg(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == s.trim().length();
    }

    @POST
    @Path(value="/transaction/broadcastWithNoContractValidation")
    @Produces(value={"application/json"})
    @ApiOperation(description="Broadcasting transactions(Not verifying contracts)", order=304, detailDesc="Broadcast offline assembly transactions(Not verifying contracts),Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="Broadcasting transactions(Not verifying contracts)", parameterDes="Broadcasting transactions(Not verifying contracts)form", requestType=@TypeDescriptor(value=TxForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcClientResult broadcastWithNoContractValidation(TxForm form) {
        if (form == null || StringUtils.isBlank((String)form.getTxHex())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            String txHex = form.getTxHex();
            io.nuls.base.api.provider.Result result = this.transactionTools.newTx(this.config.getChainId(), txHex);
            return ResultUtil.getRpcClientResult(result);
        }
        catch (Exception e) {
            Log.error(e);
            return RpcClientResult.getFailed(e.getMessage());
        }
    }

    @POST
    @Path(value="/transaction/broadcastTxWithoutAnyValidation")
    @Produces(value={"application/json"})
    @ApiOperation(description="Broadcasting transactions(Do not verify)", order=305, detailDesc="Broadcast offline assembly transactions(Do not verify),Successfully returnedtrue,Failure returns error message")
    @Parameters(value={@Parameter(parameterName="Broadcasting transactions(Do not verify)", parameterDes="Broadcasting transactions(Do not verify)form", requestType=@TypeDescriptor(value=TxForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful"), @Key(name="hash", description="transactionhash")}))
    public RpcClientResult broadcastTxWithoutAnyValidation(TxForm form) {
        if (form == null || StringUtils.isBlank((String)form.getTxHex())) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        try {
            String txHex = form.getTxHex();
            io.nuls.base.api.provider.Result result = this.transactionTools.broadcastTxWithoutAnyValidation(this.config.getChainId(), txHex);
            return ResultUtil.getRpcClientResult(result);
        }
        catch (Exception e) {
            Log.error(e);
            return RpcClientResult.getFailed(e.getMessage());
        }
    }

    @POST
    @Path(value="/transfer")
    @Produces(value={"application/json"})
    @ApiOperation(description="Single transfer", order=306, detailDesc="Initiate transfer transactions for a single account or asset")
    @Parameters(value={@Parameter(parameterName="Single transfer", parameterDes="Single transfer form", requestType=@TypeDescriptor(value=TransferForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult transfer(TransferForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        if (form.getAssetChainId() == 0) {
            form.setAssetChainId(this.config.getChainId());
        }
        if (form.getAssetId() == 0) {
            form.setAssetId(this.config.getAssetsId());
        }
        TransferReq.TransferReqBuilder builder = new TransferReq.TransferReqBuilder(this.config.getChainId(), Integer.valueOf(form.getAssetId())).addForm(form.getAddress(), form.getPassword(), form.getAmount()).addTo(form.getToAddress(), form.getAmount()).setRemark(form.getRemark());
        TransferReq req = builder.build(new TransferReq());
        ((TransferReq.Item)req.getInputs().get(0)).setAssetsChainId(Integer.valueOf(form.getAssetChainId()));
        ((TransferReq.Item)req.getOutputs().get(0)).setAssetsChainId(Integer.valueOf(form.getAssetChainId()));
        io.nuls.base.api.provider.Result result = this.transferService.transfer(req);
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("value", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/crossTransfer")
    @Produces(value={"application/json"})
    @ApiOperation(description="Cross chain transfer", order=306, detailDesc="Initiate cross chain transfer transactions for single account and single asset transactions")
    @Parameters(value={@Parameter(parameterName="Cross chain transfer", parameterDes="Cross chain transfer form", requestType=@TypeDescriptor(value=CrossTransferForm.class))})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="transactionhash")}))
    public RpcClientResult crossTransfer(CrossTransferForm form) {
        if (form == null) {
            return RpcClientResult.getFailed(new ErrorData(CommonCodeConstanst.PARAMETER_ERROR.getCode(), "form is empty"));
        }
        CreateCrossTxReq.CreateCrossTxReqBuilder builder = new CreateCrossTxReq.CreateCrossTxReqBuilder(this.config.getChainId()).addForm(Integer.valueOf(form.getAssetChainId()), Integer.valueOf(form.getAssetId()), form.getAddress(), form.getPassword(), form.getAmount()).addTo(Integer.valueOf(form.getAssetChainId()), Integer.valueOf(form.getAssetId()), form.getToAddress(), form.getAmount()).setRemark(form.getRemark());
        io.nuls.base.api.provider.Result result = this.crossChainProvider.createCrossTx(builder.build());
        RpcClientResult clientResult = ResultUtil.getRpcClientResult(result);
        if (clientResult.isSuccess()) {
            return clientResult.resultMap().map("txHash", clientResult.getData()).mapToData();
        }
        return clientResult;
    }

    @POST
    @Path(value="/createTransferTxOffline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly transfer transaction", order=350, detailDesc="according toinputsandoutputsOffline assembly transfer transaction, used for single account or multi account transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the Li Ben Chain")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Transfer transaction form", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcClientResult createTransferTxOffline(TransferDto transferDto) {
        try {
            CommonValidator.checkTransferDto((TransferDto)transferDto);
            Result result = NulsSDKTool.createTransferTxOffline((TransferDto)transferDto);
            return ResultUtil.getRpcClientResult(result);
        }
        catch (NulsException e) {
            return RpcClientResult.getFailed(new ErrorData(e.getErrorCode().getCode(), e.getMessage()));
        }
    }

    @POST
    @Path(value="/createCrossTxOffline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Offline assembly of cross chain transfer transactions", order=350, detailDesc="according toinputsandoutputsOffline assembly of cross chain transfer transactions, used for single account or multi account transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the local chain, plus the cross chain transferNULSHandling fees")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Cross chain transfer transaction form", requestType=@TypeDescriptor(value=TransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcClientResult createCrossTxOffline(TransferDto transferDto) {
        try {
            CommonValidator.checkTransferDto((TransferDto)transferDto);
            Result result = NulsSDKTool.createCrossTransferTxOffline((TransferDto)transferDto);
            return ResultUtil.getRpcClientResult(result);
        }
        catch (NulsException e) {
            return RpcClientResult.getFailed(new ErrorData(e.getErrorCode().getCode(), e.getMessage()));
        }
    }

    @POST
    @Path(value="/calcTransferTxFee")
    @Produces(value={"application/json"})
    @ApiOperation(description="Calculate the transaction fee required for offline creation of transfer transactions", order=351)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="Transfer transaction fees", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcClientResult calcTransferTxFee(TransferTxFeeDto dto) {
        BigInteger fee = NulsSDKTool.calcTransferTxFee((TransferTxFeeDto)dto);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", fee.toString());
        RpcClientResult result = RpcClientResult.getSuccess(map);
        return result;
    }

    @POST
    @Path(value="/calcCrossTxFee")
    @Produces(value={"application/json"})
    @ApiOperation(description="Calculate the transaction fee required for offline creation of cross chain transfer transactions", order=351)
    @Parameters(value={@Parameter(parameterName="TransferTxFeeDto", parameterDes="Transfer transaction fees", requestType=@TypeDescriptor(value=TransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcClientResult calcCrossTxFee(CrossTransferTxFeeDto dto) {
        Map map = NulsSDKTool.calcCrossTransferTxFee((CrossTransferTxFeeDto)dto);
        RpcClientResult result = RpcClientResult.getSuccess(map);
        return result;
    }

    @POST
    @Path(value="/createMultiSignTransferTxOffline")
    @Produces(value={"application/json"})
    @ApiOperation(description="Multiple account offline assembly transfer transactions", order=352, detailDesc="according toinputsandoutputsOffline assembly transfer transaction, used for single account or multi account transfer transactions.The transaction fee isinputsThe total amount of main assets in the Li Ben Chain, minusoutputsThe total amount of main assets in the Li Ben Chain")
    @Parameters(value={@Parameter(parameterName="transferDto", parameterDes="Multi signature account transfer transaction form", requestType=@TypeDescriptor(value=MultiSignTransferDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="hash", description="transactionhash"), @Key(name="txHex", description="Transaction serialization16Hexadecimal Strings")}))
    public RpcClientResult createMultiTransferTxOffline(MultiSignTransferDto transferDto) {
        try {
            CommonValidator.checkMultiSignTransferDto((MultiSignTransferDto)transferDto);
            Result result = NulsSDKTool.createMultiSignTransferTxOffline((MultiSignTransferDto)transferDto);
            return ResultUtil.getRpcClientResult(result);
        }
        catch (NulsException e) {
            return RpcClientResult.getFailed(new ErrorData(e.getErrorCode().getCode(), e.getMessage()));
        }
    }

    @POST
    @Path(value="/calcMultiSignTransferTxFee")
    @Produces(value={"application/json"})
    @ApiOperation(description="Calculate the transaction fee required for offline creation of multi signature account transfer transactions", order=353)
    @Parameters(value={@Parameter(parameterName="MultiSignTransferTxFeeDto", parameterDes="Multiple account transfer transaction fee form", requestType=@TypeDescriptor(value=MultiSignTransferTxFeeDto.class))})
    @ResponseData(name="Return value", description="Return aMapobject", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Transaction fees")}))
    public RpcClientResult calcMultiSignTransferTxFee(MultiSignTransferTxFeeDto dto) {
        BigInteger fee = NulsSDKTool.calcMultiSignTransferTxFee((MultiSignTransferTxFeeDto)dto);
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        map.put("value", fee);
        RpcClientResult result = RpcClientResult.getSuccess(map);
        return result;
    }
}

