/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.api.resources;

import io.nuls.base.api.provider.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.api.config.Config;
import io.nuls.provider.model.RpcClientResult;
import io.nuls.provider.rpctools.BlockTools;
import io.nuls.provider.utils.ResultUtil;
import io.nuls.v2.model.annotation.Api;
import io.nuls.v2.model.annotation.ApiOperation;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/")
@Component
@Api
public class SystemResource {
    @Autowired
    private Config config;
    @Autowired
    BlockTools blockTools;

    @GET
    @Produces(value={"application/json"})
    public RpcClientResult desc() {
        return RpcClientResult.getSuccess("Supports two methods,restful - http://{ip}:{port}/api & jsonrpc - http://{ip}:{port}/jsonrpc");
    }

    @GET
    @Path(value="api/info")
    @Produces(value={"application/json"})
    @ApiOperation(description="Obtain information related to this chain", order=1)
    @ResponseData(name="Return value", description="Return this chain information", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", description="This chain'sID"), @Key(name="assetId", description="This chain defaults to the main asset'sID"), @Key(name="inflationAmount", description="The initial quantity of the default main asset in this chain"), @Key(name="agentChainId", description="The chain of consensus assets in this chainID"), @Key(name="agentAssetId", description="The consensus assets of this chainID"), @Key(name="addressPrefix", description="Prefix for this chain address"), @Key(name="symbol", description="Main asset symbol of this chain")}))
    public RpcClientResult info() {
        Result<Map> result = this.blockTools.getInfo(this.config.getChainId());
        if (result.isSuccess()) {
            Map map = (Map)result.getData();
            map.put("chainId", this.config.getChainId());
            map.put("assetId", this.config.getAssetsId());
            map.put("addressPrefix", this.config.getAddressPrefix());
            map.put("symbol", this.config.getSymbol());
            map.remove("awardAssetId");
            map.remove("seedNodes");
        }
        return ResultUtil.getRpcClientResult(result);
    }
}

