/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.model.dto;

import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.provider.model.dto.ContractResultDto;
import io.nuls.provider.model.dto.InputDto;
import io.nuls.provider.model.dto.OutputDto;
import java.util.List;
import java.util.Map;

@ApiModel
public class ContractTransactionDto {
    @ApiModelProperty(description="transactionhash")
    private String hash;
    @ApiModelProperty(description="Transaction type")
    private Integer type;
    @ApiModelProperty(description="Transaction time")
    private Long time;
    @ApiModelProperty(description="block height")
    private Long blockHeight;
    @ApiModelProperty(description="Transaction fees")
    private String fee;
    @ApiModelProperty(description="Transaction amount")
    private String value;
    @ApiModelProperty(description="Remarks")
    private String remark;
    @ApiModelProperty(description="Signature information")
    private String scriptSig;
    @ApiModelProperty(description="Transaction status\uff080 - Confirming,1 - Confirmed\uff09")
    private Integer status;
    @ApiModelProperty(description="Number of transaction confirmations")
    private Long confirmCount;
    @ApiModelProperty(description="Transaction size")
    private int size;
    @ApiModelProperty(description="Transaction Input Set", type=@TypeDescriptor(value=List.class, collectionElement=InputDto.class))
    private List<InputDto> inputs;
    @ApiModelProperty(description="Transaction output set", type=@TypeDescriptor(value=List.class, collectionElement=OutputDto.class))
    private List<OutputDto> outputs;
    @ApiModelProperty(description="Contract trading business data", type=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="data", description="Reflect different business data based on contract transaction types\uff08Here, in order to describe four situations, the four businesses are described together, but in reality, they do not exist simultaneously, only one exists\uff09")}))
    private Map<String, Object> txData;
    @ApiModelProperty(description="Contract execution results")
    private ContractResultDto contractResult;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getTime() {
        return this.time;
    }

    public void setTime(Long time) {
        this.time = time;
    }

    public Long getBlockHeight() {
        return this.blockHeight;
    }

    public void setBlockHeight(Long blockHeight) {
        this.blockHeight = blockHeight;
    }

    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getScriptSig() {
        return this.scriptSig;
    }

    public void setScriptSig(String scriptSig) {
        this.scriptSig = scriptSig;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getConfirmCount() {
        return this.confirmCount;
    }

    public void setConfirmCount(Long confirmCount) {
        this.confirmCount = confirmCount;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<InputDto> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputDto> inputs) {
        this.inputs = inputs;
    }

    public List<OutputDto> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<OutputDto> outputs) {
        this.outputs = outputs;
    }

    public Map<String, Object> getTxData() {
        return this.txData;
    }

    public void setTxData(Map<String, Object> txData) {
        this.txData = txData;
    }

    public ContractResultDto getContractResult() {
        return this.contractResult;
    }

    public void setContractResult(ContractResultDto contractResult) {
        this.contractResult = contractResult;
    }
}

