/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.model.dto;

import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.CoinTo;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;
import io.nuls.v2.util.ContractUtil;
import java.math.BigInteger;

@ApiModel
public class OutputDto {
    @ApiModelProperty(description="Output address")
    private String address;
    @ApiModelProperty(description="Asset ChainID")
    private int assetsChainId;
    @ApiModelProperty(description="assetID")
    private int assetsId;
    @ApiModelProperty(description="Output amount")
    private String amount;
    @ApiModelProperty(description="Lock time")
    private long lockTime;

    public OutputDto() {
    }

    public OutputDto(CoinTo to) {
        this.address = AddressTool.getStringAddressByBytes((byte[])to.getAddress());
        this.assetsChainId = to.getAssetsChainId();
        this.assetsId = to.getAssetsId();
        this.amount = ContractUtil.bigInteger2String((BigInteger)to.getAmount());
        this.lockTime = to.getLockTime();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getAssetsChainId() {
        return this.assetsChainId;
    }

    public void setAssetsChainId(int assetsChainId) {
        this.assetsChainId = assetsChainId;
    }

    public int getAssetsId() {
        return this.assetsId;
    }

    public void setAssetsId(int assetsId) {
        this.assetsId = assetsId;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public long getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.lockTime = lockTime;
    }
}

