/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.rpctools;

import io.nuls.base.api.provider.Result;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.Block;
import io.nuls.base.data.Transaction;
import io.nuls.core.constant.TxStatusEnum;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.util.RpcCall;
import io.nuls.provider.rpctools.CallRpc;
import io.nuls.provider.utils.Log;
import java.util.HashMap;
import java.util.Map;

@Component
public class BlockTools
implements CallRpc {
    public Result<Block> getBlockByHeight(int chainId, long height) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        param.put("height", height);
        try {
            Block block = this.callRpc(ModuleE.BL.name, "getBlockByHeight", param, res -> {
                if (res == null || res.isEmpty()) {
                    return null;
                }
                Block _block = new Block();
                try {
                    _block.parse(new NulsByteBuffer(HexUtil.decode((String)((String)res.get("value")))));
                    for (Transaction tx : _block.getTxs()) {
                        tx.setStatus(TxStatusEnum.CONFIRMED);
                    }
                }
                catch (NulsException e) {
                    Log.error(e);
                    return null;
                }
                return _block;
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Block> getBlockByHash(int chainId, String hash) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        param.put("hash", hash);
        try {
            Block block = this.callRpc(ModuleE.BL.name, "getBlockByHash", param, res -> {
                if (res == null || res.isEmpty()) {
                    return null;
                }
                Block _block = new Block();
                try {
                    _block.parse(new NulsByteBuffer(HexUtil.decode((String)((String)res.get("value")))));
                    for (Transaction tx : _block.getTxs()) {
                        tx.setStatus(TxStatusEnum.CONFIRMED);
                    }
                }
                catch (NulsException e) {
                    Log.error(e);
                    return null;
                }
                return _block;
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Block> getBestBlock(int chainId) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        try {
            Block block = this.callRpc(ModuleE.BL.name, "latestBlock", param, res -> {
                if (res == null || res.isEmpty()) {
                    return null;
                }
                Block _block = new Block();
                try {
                    _block.parse(new NulsByteBuffer(HexUtil.decode((String)((String)res.get("value")))));
                    for (Transaction tx : _block.getTxs()) {
                        tx.setStatus(TxStatusEnum.CONFIRMED);
                    }
                }
                catch (NulsException e) {
                    Log.error(e);
                    return null;
                }
                return _block;
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<Map> getInfo(int chainId) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("chainId", chainId);
        try {
            Map map = (Map)RpcCall.request((String)ModuleE.CS.abbr, (String)"cs_getConsensusConfig", params);
            return new Result((Object)map);
        }
        catch (NulsException e) {
            return Result.fail((String)e.getErrorCode().getCode(), (String)e.getMessage());
        }
    }

    public Result<String> getBlockSerializationByHeight(int chainId, long height) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        param.put("height", height);
        try {
            String block = this.callRpc(ModuleE.BL.name, "getBlockByHeight", param, res -> {
                if (res == null || res.isEmpty()) {
                    return null;
                }
                return (String)res.get("value");
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<String> getBlockSerializationByHash(int chainId, String hash) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        param.put("hash", hash);
        try {
            String block = this.callRpc(ModuleE.BL.name, "getBlockByHash", param, res -> {
                if (res == null || res.isEmpty()) {
                    return null;
                }
                return (String)res.get("value");
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }

    public Result<String> latestHeight(int chainId) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("chainId", chainId);
        try {
            Long block = this.callRpc(ModuleE.BL.name, "latestHeight", param, res -> {
                Object value = res.get("value");
                if (value == null) {
                    return -1L;
                }
                return Long.parseLong(value.toString());
            });
            return new Result((Object)block);
        }
        catch (NulsRuntimeException e) {
            return Result.fail((String)e.getCode(), (String)e.getMessage());
        }
    }
}

