/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.provider.utils;

import io.nuls.base.RPCUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.CoinData;
import io.nuls.base.data.CoinTo;
import io.nuls.base.data.Transaction;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.base.signture.SignatureUtil;
import io.nuls.base.signture.TransactionSignature;
import io.nuls.core.constant.CommonCodeConstanst;
import io.nuls.core.crypto.AESEncrypt;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.CryptoException;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.ObjectUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.provider.utils.ApiDocTool;
import io.nuls.v2.model.dto.ProgramMultyAssetValue;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Utils {
    public static Transaction signTransaction(Transaction transaction, String priKey, String pubKey, String password) throws IOException {
        TransactionSignature transactionSignature = new TransactionSignature();
        ArrayList<P2PHKSignature> p2PHKSignatures = new ArrayList<P2PHKSignature>();
        ECKey eckey = null;
        BigInteger newPriv = null;
        ObjectUtils.canNotEmpty((Object)password, (String)"the password can not be empty");
        try {
            byte[] unencryptedPrivateKey = AESEncrypt.decrypt((byte[])HexUtil.decode((String)priKey), (String)password);
            newPriv = new BigInteger(1, unencryptedPrivateKey);
        }
        catch (CryptoException e) {
            throw new NulsRuntimeException(CommonCodeConstanst.FAILED, "password is wrong");
        }
        eckey = ECKey.fromPrivate((BigInteger)newPriv);
        if (!Arrays.equals(eckey.getPubKey(), HexUtil.decode((String)pubKey))) {
            throw new NulsRuntimeException(CommonCodeConstanst.FAILED, "password is wrong");
        }
        P2PHKSignature p2PHKSignature = SignatureUtil.createSignatureByEckey((Transaction)transaction, (ECKey)eckey);
        p2PHKSignatures.add(p2PHKSignature);
        transactionSignature.setP2PHKSignatures(p2PHKSignatures);
        transaction.setTransactionSignature(transactionSignature.serialize());
        return transaction;
    }

    public static int extractTxTypeFromTx(String txString) throws NulsException {
        String txTypeHexString = txString.substring(0, 4);
        NulsByteBuffer byteBuffer = new NulsByteBuffer(RPCUtil.decode((String)txTypeHexString));
        return byteBuffer.readUint16();
    }

    public static int getDepth(Class cls) {
        return Utils.getDepth(cls, 1);
    }

    private static int getDepth(Class cls, int depth) {
        if (depth > 3) {
            throw new RuntimeException("exceed depth");
        }
        if (ApiDocTool.baseType.contains(cls)) {
            return depth;
        }
        Field[] fields = cls.getDeclaredFields();
        int max = depth;
        try {
            for (Field field : fields) {
                int initial = depth;
                if (ApiDocTool.baseType.contains(field.getType())) continue;
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    ++initial;
                    ParameterizedType pType = (ParameterizedType)genericType;
                    Type[] typeArguments = pType.getActualTypeArguments();
                    for (int i = 0; i < typeArguments.length; ++i) {
                        Class<?> aClass = Class.forName(typeArguments[i].getTypeName());
                        if (ApiDocTool.baseType.contains(aClass)) continue;
                        int i1 = Utils.getDepth(aClass, initial);
                        max = Math.max(i1, max);
                    }
                    continue;
                }
                Class<?> aClass = Class.forName(genericType.getTypeName());
                if (aClass != field.getType()) continue;
                int i1 = Utils.getDepth(aClass, ++initial);
                max = Math.max(i1, max);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return max;
    }

    public static String[][] extractMultyAssetInfoFromCallTransaction(byte[] contractAddress, CoinData coinData, int mainChainId, int mainAssetId) {
        List toList = coinData.getTo();
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        ArrayList<String[]> list = null;
        for (CoinTo to : toList) {
            if (to.getAssetsChainId() == mainChainId && to.getAssetsId() == mainAssetId || !Arrays.equals(contractAddress, to.getAddress())) continue;
            if (list == null) {
                list = new ArrayList<String[]>();
            }
            list.add(new String[]{to.getAmount().toString(), String.valueOf(to.getAssetsChainId()), String.valueOf(to.getAssetsId())});
        }
        if (list == null) {
            return null;
        }
        int length = list.size();
        String[][] array = new String[length][];
        for (int i = 0; i < length; ++i) {
            array[i] = (String[])list.get(i);
        }
        return array;
    }

    public static List<ProgramMultyAssetValue> multyAssetObjectArray(String[][] multyAssetValues) {
        int length;
        if (multyAssetValues == null || (length = multyAssetValues.length) == 0) {
            return null;
        }
        ArrayList<ProgramMultyAssetValue> list = new ArrayList<ProgramMultyAssetValue>(length);
        for (int i = 0; i < length; ++i) {
            String[] value = multyAssetValues[i];
            list.add(new ProgramMultyAssetValue(new BigInteger(value[0]), String.valueOf(value[3]), Integer.valueOf(value[1]).intValue(), Integer.valueOf(value[2]).intValue()));
        }
        return list;
    }

    public static byte[] dataToBytes(String data) {
        if (StringUtils.isBlank((String)data)) {
            return null;
        }
        try {
            char[] chars;
            boolean isHex = true;
            String validData = Utils.cleanHexPrefix(data);
            for (char c : chars = validData.toCharArray()) {
                int digit = Character.digit(c, 16);
                if (digit != -1) continue;
                isHex = false;
                break;
            }
            if (isHex) {
                return HexUtil.decode((String)validData);
            }
            return data.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return data.getBytes(StandardCharsets.UTF_8);
        }
    }

    private static String cleanHexPrefix(String input) {
        return Utils.containsHexPrefix(input) ? input.substring(2) : input;
    }

    private static boolean containsHexPrefix(String input) {
        return !StringUtils.isBlank((String)input) && input.length() > 1 && input.charAt(0) == '0' && input.charAt(1) == 'x';
    }
}

