/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.bo.tx.txdata;

import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;

public class AccountContractCallData
extends BaseNulsData {
    private String[] addresses;
    private int type;
    private byte[] extend;

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        for (String address : this.addresses) {
            size += SerializeUtils.sizeOfString((String)address);
        }
        size += SerializeUtils.sizeOfUint16();
        return size += SerializeUtils.sizeOfBytes((byte[])this.extend);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.addresses.length);
        for (String address : this.addresses) {
            stream.writeString(address);
        }
        stream.writeUint16(this.type);
        stream.writeBytesWithLength(this.extend);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        int length = byteBuffer.readUint16();
        String[] _addresses = new String[length];
        for (int i = 0; i < length; ++i) {
            _addresses[i] = byteBuffer.readString();
        }
        this.addresses = _addresses;
        this.type = byteBuffer.readUint16();
        this.extend = byteBuffer.readByLengthByte();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }
}

