/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.dto;

import io.nuls.account.model.bo.Account;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.rpc.model.ApiModel;
import io.nuls.core.rpc.model.ApiModelProperty;

@ApiModel
public class SimpleAccountDTO {
    @ApiModelProperty(description="Account address")
    private String address;
    @ApiModelProperty(description="alias")
    private String alias;
    @ApiModelProperty(description="Public key")
    private String pubkeyHex;
    @ApiModelProperty(description="Encrypted private key")
    private String encryptedPrikeyHex;

    public SimpleAccountDTO() {
    }

    public SimpleAccountDTO(Account account) {
        this.address = account.getAddress().getBase58();
        this.alias = account.getAlias();
        this.pubkeyHex = HexUtil.encode((byte[])account.getPubKey());
        if (account.getEncryptedPriKey() != null) {
            this.encryptedPrikeyHex = HexUtil.encode((byte[])account.getEncryptedPriKey());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getPubkeyHex() {
        return this.pubkeyHex;
    }

    public void setPubkeyHex(String pubkeyHex) {
        this.pubkeyHex = pubkeyHex;
    }

    public String getEncryptedPrikeyHex() {
        return this.encryptedPrikeyHex;
    }

    public void setEncryptedPrikeyHex(String encryptedPrikeyHex) {
        this.encryptedPrikeyHex = encryptedPrikeyHex;
    }
}

