/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.model.po;

import io.nuls.account.model.bo.Account;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.basic.NulsOutputStreamBuffer;
import io.nuls.base.data.Address;
import io.nuls.base.data.BaseNulsData;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.EncryptedData;
import io.nuls.core.exception.NulsException;
import io.nuls.core.parse.SerializeUtils;
import java.io.IOException;
import java.math.BigInteger;

public class AccountPO
extends BaseNulsData {
    private transient Address addressObj;
    private String address;
    private int chainId;
    private Long createTime;
    private String alias;
    private byte[] pubKey;
    private byte[] priKey;
    private byte[] encryptedPriKey;
    private byte[] extend;
    private int status;
    private String remark;

    public AccountPO() {
    }

    public AccountPO(Account account) {
        this.addressObj = account.getAddress();
        this.chainId = account.getChainId();
        this.address = account.getAddress().toString();
        this.alias = account.getAlias();
        this.pubKey = account.getPubKey();
        this.priKey = account.getPriKey();
        this.encryptedPriKey = account.getEncryptedPriKey();
        this.extend = account.getExtend();
        this.remark = account.getRemark();
        this.createTime = account.getCreateTime();
    }

    public Account toAccount() {
        Account account = new Account();
        account.setChainId(this.getChainId());
        try {
            account.setAddress(Address.fromHashs((String)this.getAddress()));
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e);
        }
        account.setAlias(this.getAlias());
        account.setExtend(this.getExtend());
        account.setPriKey(this.getPriKey());
        account.setPubKey(this.getPubKey());
        account.setEncryptedPriKey(this.getEncryptedPriKey());
        if (this.getPriKey() != null && this.getPriKey().length > 1) {
            account.setEcKey(ECKey.fromPrivate((BigInteger)new BigInteger(1, account.getPriKey())));
        } else {
            account.setEcKey(ECKey.fromEncrypted((EncryptedData)new EncryptedData(this.getEncryptedPriKey()), (byte[])this.getPubKey()));
        }
        account.setRemark(this.remark);
        account.setCreateTime(this.getCreateTime());
        return account;
    }

    public int size() {
        int size = 0;
        size += SerializeUtils.sizeOfUint16();
        size += SerializeUtils.sizeOfString((String)this.address);
        size += SerializeUtils.sizeOfString((String)this.alias);
        size += SerializeUtils.sizeOfUint48();
        size += SerializeUtils.sizeOfBytes((byte[])this.pubKey);
        size += SerializeUtils.sizeOfBytes((byte[])this.priKey);
        size += SerializeUtils.sizeOfBytes((byte[])this.encryptedPriKey);
        size += SerializeUtils.sizeOfBytes((byte[])this.extend);
        return size += SerializeUtils.sizeOfString((String)this.remark);
    }

    protected void serializeToStream(NulsOutputStreamBuffer stream) throws IOException {
        stream.writeUint16(this.chainId);
        stream.writeString(this.address);
        stream.writeString(this.alias);
        stream.writeUint48(this.createTime.longValue());
        stream.writeBytesWithLength(this.pubKey);
        stream.writeBytesWithLength(this.priKey);
        stream.writeBytesWithLength(this.encryptedPriKey);
        stream.writeBytesWithLength(this.extend);
        stream.writeString(this.remark);
    }

    public void parse(NulsByteBuffer byteBuffer) throws NulsException {
        this.chainId = byteBuffer.readUint16();
        this.address = byteBuffer.readString();
        this.alias = byteBuffer.readString();
        this.createTime = byteBuffer.readUint48();
        this.pubKey = byteBuffer.readByLengthByte();
        this.priKey = byteBuffer.readByLengthByte();
        this.encryptedPriKey = byteBuffer.readByLengthByte();
        this.extend = byteBuffer.readByLengthByte();
        this.remark = byteBuffer.readString();
    }

    public Address getAddressObj() {
        return this.addressObj;
    }

    public void setAddressObj(Address addressObj) {
        this.addressObj = addressObj;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getChainId() {
        return this.chainId;
    }

    public void setChainId(int chainId) {
        this.chainId = chainId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public byte[] getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(byte[] pubKey) {
        this.pubKey = pubKey;
    }

    public byte[] getPriKey() {
        return this.priKey;
    }

    public void setPriKey(byte[] priKey) {
        this.priKey = priKey;
    }

    public byte[] getEncryptedPriKey() {
        return this.encryptedPriKey;
    }

    public void setEncryptedPriKey(byte[] encryptedPriKey) {
        this.encryptedPriKey = encryptedPriKey;
    }

    public byte[] getExtend() {
        return this.extend;
    }

    public void setExtend(byte[] extend) {
        this.extend = extend;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}

