/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.AccountKeyStore;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.dto.AccountKeyStoreDTO;
import io.nuls.account.model.dto.AccountOfflineDTO;
import io.nuls.account.model.dto.SimpleAccountDTO;
import io.nuls.account.service.AccountKeyStoreService;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.storage.AccountForTransferOnContractCallStorageService;
import io.nuls.account.util.AccountTool;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.Preconditions;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.Address;
import io.nuls.base.signture.BlockSignature;
import io.nuls.base.signture.P2PHKSignature;
import io.nuls.core.basic.Page;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.ECKey;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class AccountCmd
extends BaseCmd {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountKeyStoreService keyStoreService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AccountForTransferOnContractCallStorageService accountForTransferOnContractCallStorageService;

    @CmdAnnotation(cmd="ac_createAccount", version=1.0, description="Create a specified number of accounts/create a specified number of accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Number of accounts to be created"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="The set of account addresses created")}))
    public Response createAccount(Map params) {
        HashMap map = new HashMap(2);
        ArrayList list = new ArrayList();
        Chain chain = null;
        try {
            String password;
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object countObj = params == null ? null : params.get("count");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            int count = countObj != null ? (Integer)countObj : 0;
            List<Account> accountList = this.accountService.createAccount(chain, count, password = (String)passwordObj);
            if (accountList != null) {
                accountList.forEach(account -> list.add(account.getAddress().toString()));
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        map.put("list", list);
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_createOfflineAccount", version=1.0, description="Create an offline account, This account is not saved to the database, And will directly return all information of the account/create an offline account, which is not saved to the database and will directly return all information to the account.")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="count", requestType=@TypeDescriptor(value=int.class), parameterDes="Number of accounts to be created"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=AccountOfflineDTO.class, description="Offline account collection")}))
    public Response createOfflineAccount(Map params) {
        HashMap map = new HashMap(2);
        ArrayList<AccountOfflineDTO> accounts = new ArrayList<AccountOfflineDTO>();
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object countObj = params == null ? null : params.get("count");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            int count = countObj != null ? (Integer)countObj : 0;
            String password = passwordObj;
            if (count <= 0 || count > 100) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
            }
            if (!FormatValidUtils.validPassword((String)password)) {
                throw new NulsRuntimeException(AccountErrorCode.PASSWORD_FORMAT_WRONG);
            }
            for (int i = 0; i < count; ++i) {
                Account account = AccountTool.createAccount(chain.getChainId());
                if (StringUtils.isNotBlank((String)password)) {
                    account.encrypt(password);
                }
                accounts.add(new AccountOfflineDTO(account));
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        map.put("list", accounts);
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_createContractAccount", version=1.0, description="Create a smart contract account/create smart contract account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Smart contract address")}))
    public Response createContractAccount(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Object chainIdObj;
            Object v0 = chainIdObj = params == null ? null : params.get("chainId");
            if (params == null || chainIdObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            Address contractAddress = AccountTool.createContractAddress(chain.getChainId());
            if (contractAddress != null) {
                map.put("address", contractAddress.toString());
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_getAccountByAddress", version=1.0, description="Obtain account information through address/get account info according to address")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address")})
    @ResponseData(name="Return value", responseType=@TypeDescriptor(value=SimpleAccountDTO.class))
    public Response getAccountByAddress(Map params) {
        Account account;
        Chain chain = null;
        try {
            Object addressObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = addressObj = params == null ? null : params.get("address");
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            account = this.accountService.getAccount(chain.getChainId(), address);
            if (null == account) {
                return this.success(null);
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(new SimpleAccountDTO(account));
    }

    @CmdAnnotation(cmd="ac_getAccountList", version=1.0, description="Get all account collections,And put it in cache/query all account collections and put them in cache")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=SimpleAccountDTO.class, description="Return account collection")}))
    public Response getAccountList(Map params) {
        HashMap map = new HashMap(2);
        ArrayList simpleAccountList = new ArrayList();
        Chain chain = null;
        try {
            Object chainIdObj = params == null ? null : params.get("chainId");
            chain = this.chainManager.getChain((Integer)chainIdObj);
            List<Account> accountList = chain != null ? this.accountService.getAccountListByChain(chain.getChainId()) : this.accountService.getAccountList();
            if (null == accountList) {
                map.put("list", simpleAccountList);
                return this.success(map);
            }
            accountList.forEach(account -> simpleAccountList.add(new SimpleAccountDTO((Account)account)));
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        map.put("list", simpleAccountList);
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_getEncryptedAddressList", version=1.0, description="Get a list of local encrypted accounts/Get a list of locally encrypted accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="Return account address set")}))
    public Response getEncryptedAddressList(Map params) {
        Chain chain = null;
        HashMap map = new HashMap(2);
        ArrayList<String> encryptedAddressList = new ArrayList<String>();
        map.put("list", encryptedAddressList);
        try {
            Object chainIdObj = params == null ? null : params.get("chainId");
            chain = this.chainManager.getChain((Integer)chainIdObj);
            List<Account> accountList = chain != null ? this.accountService.getAccountListByChain(chain.getChainId()) : this.accountService.getAccountList();
            if (null == accountList) {
                return this.success(map);
            }
            for (Account account : accountList) {
                if (!account.isEncrypted()) continue;
                encryptedAddressList.add(account.getAddress().getBase58());
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_getAddressList", version=1.0, description="Pagination query account address list/Paging query account address list")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="pageNumber", requestType=@TypeDescriptor(value=int.class), parameterDes="Page number"), @Parameter(parameterName="pageSize", requestType=@TypeDescriptor(value=int.class), parameterDes="Number of records per page")})
    @ResponseData(name="Return value", description="Return aPageObject, Account Collection", responseType=@TypeDescriptor(value=List.class, collectionElement=String.class))
    public Response getAddressList(Map params) {
        Chain chain = null;
        try {
            Object pageSizeObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object pageNumberObj = params == null ? null : params.get("pageNumber");
            Object v0 = pageSizeObj = params == null ? null : params.get("pageSize");
            if (params == null || chainIdObj == null || pageNumberObj == null || pageSizeObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            Integer pageNumber = pageNumberObj;
            Integer pageSize = pageSizeObj;
            if (pageNumber < 1 || pageSize < 1) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
            }
            Page page = new Page(pageNumber.intValue(), pageSize.intValue());
            ArrayList addressList = new ArrayList();
            List<Account> accountList = this.accountService.getAccountListByChain(chain.getChainId());
            if (null == accountList) {
                page.setList(addressList);
                return this.success(page);
            }
            page.setTotal((long)accountList.size());
            int start = (pageNumber - 1) * pageSize;
            if (start >= accountList.size()) {
                page.setList(addressList);
                return this.success(page);
            }
            int end = pageNumber * pageSize;
            if (end > accountList.size()) {
                end = accountList.size();
            }
            accountList = accountList.subList(start, end);
            accountList.forEach(account -> addressList.add(account.getAddress().getBase58()));
            page.setList(addressList);
            return this.success(page);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_removeAccount", version=1.0, description="Remove specified account/Remove specified account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response removeAccount(Map params) {
        boolean result;
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            result = this.accountService.removeAccount(chain.getChainId(), address, password);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        map.put("value", result);
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_getPubKey", version=1.0, description="Based on account address and password,Query account public key/Get the account's public key")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap, including onekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="pubKey", description="Public key")}))
    public Response getPubKey(Map params) {
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            String publicKey = this.accountService.getPublicKey(chain.getChainId(), address, password);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("pubKey", publicKey);
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_getPriKeyByAddress", version=1.0, description="By account address and password,Query account private key/Inquire the account's private key according to the address")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap, including twokey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="priKey", description="Private key"), @Key(name="pubKey", description="Public key")}))
    public Response getPriKeyByAddress(Map params) {
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            if (!AddressTool.validAddress((int)chain.getChainId(), (String)address)) {
                return this.failed(AccountErrorCode.ADDRESS_ERROR);
            }
            int chainId = chain.getChainId();
            Account account = this.accountService.getAccount(chainId, address);
            String unencryptedPrivateKey = this.accountService.getPrivateKey(chain.getChainId(), account, password);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("priKey", unencryptedPrivateKey);
            map.put("pubKey", HexUtil.encode((byte[])account.getPubKey()));
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_getAllPriKey", version=1.0, description="To obtain all local account private keys, it is necessary to ensure that all account passwords are consistent. If the passwords in the local account are inconsistent, an error message will be returned/Get the all local private keys. if the password in the local account is different, the error message will be returned.")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="list", valueType=List.class, valueElement=String.class, description="Private key set")}))
    public Response getAllPriKey(Map params) {
        HashMap map = new HashMap(2);
        List<Object> privateKeyList = new ArrayList();
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String password = passwordObj;
            privateKeyList = this.accountService.getAllPrivateKey(chain.getChainId(), password);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        map.put("list", privateKeyList);
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_setRemark", version=1.0, description="Set notes for the account/Set remark for accounts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="remark", parameterType="String", parameterDes="Remarks")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Whether successful")}))
    public Response setRemark(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        Chain chain = null;
        try {
            Object remarkObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object v0 = remarkObj = params == null ? null : params.get("remark");
            if (params == null || chainIdObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String remark = remarkObj;
            boolean result = this.accountService.setRemark(chain.getChainId(), address, remark);
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_importAccountByPriKey", version=1.0, description="Import account based on private key/Import accounts by private key")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="password", parameterType="String", parameterDes="Set a new password"), @Parameter(parameterName="priKey", parameterType="String", parameterDes="Account private key"), @Parameter(parameterName="overwrite", requestType=@TypeDescriptor(value=boolean.class), parameterDes="If the account already exists,Is it covered")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Imported account address")}))
    public Response importAccountByPriKey(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Object overwriteObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object priKeyObj = params == null ? null : params.get("priKey");
            Object passwordObj = params == null ? null : params.get("password");
            Object v0 = overwriteObj = params == null ? null : params.get("overwrite");
            if (params == null || chainIdObj == null || priKeyObj == null || passwordObj == null || overwriteObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String priKey = priKeyObj;
            String password = passwordObj;
            Boolean overwrite = overwriteObj;
            Account account = this.accountService.importAccountByPrikey(chain, priKey, password, overwrite);
            map.put("address", account.getAddress().toString());
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_importAccountByKeystore", version=1.0, description="according toAccountKeyStoreImport account/Import accounts by AccountKeyStore")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="password", parameterType="String", parameterDes="Set a new password"), @Parameter(parameterName="keyStore", parameterType="String", parameterDes="keyStorecharacter string"), @Parameter(parameterName="overwrite", requestType=@TypeDescriptor(value=boolean.class), parameterDes="If the account already exists,Is it covered")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Imported account address")}))
    public Response importAccountByKeystore(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            AccountKeyStoreDTO accountKeyStoreDto;
            Object overwriteObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object keyStoreObj = params == null ? null : params.get("keyStore");
            Object passwordObj = params == null ? null : params.get("password");
            Object v0 = overwriteObj = params == null ? null : params.get("overwrite");
            if (params == null || chainIdObj == null || keyStoreObj == null || passwordObj == null || overwriteObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String keyStore = keyStoreObj;
            String password = passwordObj;
            Boolean overwrite = overwriteObj;
            try {
                accountKeyStoreDto = (AccountKeyStoreDTO)JSONUtils.json2pojo((String)new String(RPCUtil.decode((String)keyStore)), AccountKeyStoreDTO.class);
            }
            catch (IOException e) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNTKEYSTORE_FILE_DAMAGED);
            }
            Account account = this.accountService.importAccountByKeyStore(accountKeyStoreDto.toAccountKeyStore(), chain, password, overwrite);
            map.put("address", account.getAddress().toString());
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CmdAnnotation(cmd="ac_importsKeyStoreFiles", version=1.0, description="according toAccountKeyStoreImport account/Import accounts by AccountKeyStore")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="dirPath", parameterType="String", parameterDes="Folder path")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Imported account address")}))
    public Response importsKeyStoreFiles(Map params) {
        Chain chain = null;
        HashMap map = new HashMap();
        BufferedReader reader = null;
        StringBuffer stringBuffer = null;
        try {
            Object pathObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = pathObj = params == null ? null : params.get("dirPath");
            if (params == null || chainIdObj == null || pathObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String dirPath = pathObj;
            File baseDir = new File(dirPath);
            if (!baseDir.exists() || !baseDir.isDirectory()) {
                throw new NulsException(AccountErrorCode.ACCOUNTKEYSTORE_FILE_NOT_EXIST);
            }
            File[] array = baseDir.listFiles();
            ArrayList<AccountKeyStore> accountKeyStoreList = new ArrayList<AccountKeyStore>();
            for (int i = 0; i < array.length; ++i) {
                String tempStr;
                if (!array[i].isFile() || !array[i].getName().endsWith(".keystore")) continue;
                reader = new BufferedReader(new FileReader(array[i]));
                stringBuffer = new StringBuffer();
                while ((tempStr = reader.readLine()) != null) {
                    stringBuffer.append(tempStr);
                }
                reader.close();
                String keystore = stringBuffer.toString();
                try {
                    AccountKeyStoreDTO accountKeyStoreDto = (AccountKeyStoreDTO)JSONUtils.json2pojo((String)keystore, AccountKeyStoreDTO.class);
                    if (StringUtils.isBlank((String)accountKeyStoreDto.getAddress()) || StringUtils.isBlank((String)accountKeyStoreDto.getEncryptedPrivateKey()) || StringUtils.isBlank((String)accountKeyStoreDto.getPubKey())) {
                        throw new NulsException(AccountErrorCode.ACCOUNTKEYSTORE_FILE_DAMAGED, array[i].getName());
                    }
                    accountKeyStoreList.add(accountKeyStoreDto.toAccountKeyStore());
                    continue;
                }
                catch (IOException e) {
                    throw new NulsException(AccountErrorCode.ACCOUNTKEYSTORE_FILE_DAMAGED, array[i].getName());
                }
            }
            this.accountService.importAccountListByKeystore(accountKeyStoreList, chain);
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            Response response = this.failed(e.getErrorCode());
            return response;
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            Response response = this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
            return response;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_exportKeyStoreJson", version=1.0, description="exportAccountKeyStorecharacter string/export account KeyStore json")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="keyStore", description="keyStorecharacter string")}))
    public Response exportKeyStoreJson(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Object passwordObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object v0 = passwordObj = params == null ? null : params.get("password");
            if (params == null || chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            AccountKeyStore accountKeyStore = this.keyStoreService.getKeyStore(chain.getChainId(), address, password);
            AccountKeyStoreDTO storeDTO = new AccountKeyStoreDTO(accountKeyStore);
            map.put("keystore", JSONUtils.obj2json((Object)storeDTO));
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_exportAccountKeyStore", version=1.0, description="Account backup, exportAccountKeyStorecharacter string/export account KeyStore")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password"), @Parameter(parameterName="filePath", parameterType="String", parameterDes="Backup address", canNull=true)})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="path", description="The actual backup file address")}))
    public Response exportAccountKeyStore(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Object filePathObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object addressObj = params == null ? null : params.get("address");
            Object passwordObj = params == null ? null : params.get("password");
            Object v0 = filePathObj = params == null ? null : params.get("filePath");
            if (params == null || chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            String filePath = filePathObj;
            String backupFileName = this.keyStoreService.backupAccountToKeyStore(filePath, chain.getChainId(), address, password);
            map.put("path", backupFileName);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_updatePassword", version=1.0, description="Change the account password based on the original password/Modify the account password by the original password")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Old account password"), @Parameter(parameterName="newPassword", parameterType="String", parameterDes="Account New Password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Is it successfully set up")}))
    public Response updatePassword(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            Object passwordObj = params.get("password");
            Object newPasswordObj = params.get("newPassword");
            if (chainIdObj == null || addressObj == null || passwordObj == null || newPasswordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            String password = (String)passwordObj;
            String newPassword = (String)newPasswordObj;
            boolean result = this.accountService.changePassword(chain.getChainId(), address, password, newPassword);
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_updateOfflineAccountPassword", version=1.0, description="Offline account password modification/Offline account change password")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Old account password"), @Parameter(parameterName="newPassword", parameterType="String", parameterDes="Account New Password"), @Parameter(parameterName="priKey", parameterType="String", parameterDes="Account private key")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="encryptedPriKey", description="Return the encrypted private key after modification")}))
    public Response updateOfflineAccountPassword(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            Object priKeyObj = params.get("priKey");
            Object passwordObj = params.get("password");
            Object newPasswordObj = params.get("newPassword");
            if (chainIdObj == null || addressObj == null || priKeyObj == null || passwordObj == null || newPasswordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            String priKey = (String)priKeyObj;
            String password = (String)passwordObj;
            String newPassword = (String)newPasswordObj;
            String encryptedPriKey = this.accountService.changeOfflinePassword(chain.getChainId(), address, priKey, password, newPassword);
            map.put("encryptedPriKey", encryptedPriKey);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_validationPassword", version=1.0, description="Verify if the account password is correct/Verify that the account password is correct")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Is the account password correct")}))
    public Response validationPassword(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            Object passwordObj = params.get("password");
            if (chainIdObj == null || addressObj == null || passwordObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            int chainId = (Integer)chainIdObj;
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            String password = (String)passwordObj;
            Account account = this.accountService.getAccount(chainId, address);
            if (null == account) {
                throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST, address);
            }
            boolean result = account.validatePassword(password);
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_validationWhitelistForTransferOnContractCall", version=1.0, description="Verify if the account is on the contract whitelist")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Is the account on the contract whitelist")}))
    public Response validationWhitelistForTransferOnContractCall(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            if (chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            int chainId = (Integer)chainIdObj;
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            boolean result = this.accountService.validationWhitelistForTransferOnContractCall(chainId, address);
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_getAllContractCallAccount", version=1.0, description="Query the whitelist of accounts that allow regular transfers when calling contracts")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class))
    public Response getAllContractCallAccount(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        try {
            if (params == null || chainIdObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            List accountList = this.accountForTransferOnContractCallStorageService.getAccountList();
            if (accountList == null) {
                accountList = Collections.EMPTY_LIST;
            }
            List collect = accountList.stream().map(a -> AddressTool.getStringAddressByBytes((byte[])a.getAddress())).collect(Collectors.toList());
            HashMap result = new HashMap(2);
            result.put("value", collect);
            return this.success(result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_signDigest", version=1.0, description="Data Summary Signature/Data digest signature")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password"), @Parameter(parameterName="data", parameterType="String", parameterDes="Data to be signed")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="signature", description="Data after signature")}))
    public Response signDigest(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            Object passwordObj = params.get("password");
            Object dataObj = params.get("data");
            if (chainIdObj == null || addressObj == null || passwordObj == null || dataObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            String password = (String)passwordObj;
            String dataStr = (String)dataObj;
            byte[] data = RPCUtil.decode((String)dataStr);
            P2PHKSignature signature = this.accountService.signDigest(data, chain.getChainId(), address, password);
            if (null == signature || signature.getSignData() == null) {
                throw new NulsRuntimeException(AccountErrorCode.SIGNATURE_ERROR);
            }
            try {
                map.put("signature", RPCUtil.encode((byte[])signature.serialize()));
            }
            catch (IOException e) {
                throw new NulsRuntimeException(AccountErrorCode.SERIALIZE_ERROR);
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_signBlockDigest", version=1.0, description="Block Data Summary Signature/Block data digest signature")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password"), @Parameter(parameterName="data", parameterType="String", parameterDes="Data to be signed")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="signature", description="Data after signature")}))
    public Response signBlockDigest(Map params) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Chain chain = null;
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object chainIdObj = params.get("chainId");
            Object addressObj = params.get("address");
            Object passwordObj = params.get("password");
            Object dataObj = params.get("data");
            if (chainIdObj == null || addressObj == null || passwordObj == null || dataObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = (String)addressObj;
            String password = (String)passwordObj;
            String dataStr = (String)dataObj;
            byte[] data = RPCUtil.decode((String)dataStr);
            BlockSignature signature = this.accountService.signBlockDigest(data, chain.getChainId(), address, password);
            if (null == signature || signature.getSignData() == null) {
                throw new NulsRuntimeException(AccountErrorCode.SIGNATURE_ERROR);
            }
            try {
                map.put("signature", RPCUtil.encode((byte[])signature.serialize()));
            }
            catch (IOException e) {
                throw new NulsRuntimeException(AccountErrorCode.SERIALIZE_ERROR);
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_verifySignData", version=1.0, description="Verify data signature/Verification Data Signature")
    @Parameters(value={@Parameter(parameterName="pubKey", parameterType="String", parameterDes="Account public key"), @Parameter(parameterName="sig", parameterType="String", parameterDes="autograph"), @Parameter(parameterName="data", parameterType="String", parameterDes="Data to be signed")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="signature", valueType=boolean.class, description="Is the signature correct")}))
    public Response verifySignData(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        try {
            Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
            Object pubKeyObj = params.get("pubKey");
            Object sigObj = params.get("sig");
            Object dataObj = params.get("data");
            if (pubKeyObj == null || sigObj == null || dataObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            byte[] pubKey = RPCUtil.decode((String)pubKeyObj.toString());
            byte[] sig = RPCUtil.decode((String)sigObj.toString());
            byte[] data = RPCUtil.decode((String)dataObj.toString());
            boolean result = true;
            if (!ECKey.verify((byte[])data, (byte[])sig, (byte[])pubKey)) {
                result = false;
            }
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            LoggerUtil.LOG.info("", (Throwable)e);
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error("", e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

