/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.Preconditions;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.parse.JSONUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class AddressPrefixCmd
extends BaseCmd {
    @CmdAnnotation(cmd="ac_getAllAddressPrefix", version=1.0, description="Get address prefixes for all chains")
    @ResponseData(name="Return value", description="Return aList", responseType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="chainId", valueType=Integer.class, description="chainid"), @Key(name="addressPrefix", valueType=String.class, description="Address prefix")}))
    public Response getAllAddressPrefix(Map params) {
        ArrayList rtList = new ArrayList();
        try {
            Map addressPreFixMap = AddressTool.getAddressPreFixMap();
            for (Map.Entry entry : addressPreFixMap.entrySet()) {
                HashMap<String, Object> rtValue = new HashMap<String, Object>();
                rtValue.put("chainId", entry.getKey());
                rtValue.put("addressPrefix", entry.getValue());
                rtList.add(rtValue);
            }
            LoggerUtil.LOG.debug(JSONUtils.obj2json(rtList));
        }
        catch (Exception e) {
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(rtList);
    }

    @CmdAnnotation(cmd="ac_getAddressPrefixByChainId", version=1.0, description="By chainidGet address prefix")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="chainId", valueType=Integer.class, description="chainid"), @Key(name="addressPrefix", valueType=String.class, description="Address prefix")}))
    public Response getAddressPrefixByChainId(Map params) {
        Preconditions.checkNotNull(params, AccountErrorCode.NULL_PARAMETER);
        Object chainIdObj = params.get("chainId");
        if (chainIdObj == null) {
            throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
        }
        int chainId = Integer.valueOf(chainIdObj.toString());
        HashMap rtValue = new HashMap();
        try {
            HashMap addressPreFixMap = new HashMap();
            rtValue.put("chainId", addressPreFixMap.get(chainId));
            rtValue.put("addressPrefix", chainId);
        }
        catch (Exception e) {
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(rtValue);
    }

    @CmdAnnotation(cmd="ac_addAddressPrefix", version=1.0, description="Add address prefix,The chain management module will call this interface")
    @Parameters(value={@Parameter(parameterName="prefixList", requestType=@TypeDescriptor(value=List.class, collectionElement=Map.class, mapKeys={@Key(name="chainId", valueType=Integer.class, description="chainid"), @Key(name="addressPrefix", valueType=String.class, description="Address prefix")}), parameterDes="Chain Address Prefix List")})
    @ResponseData(description="No specific return value, successful without errors")
    public Response addAddressPrefix(Map params) {
        List prefixList = (List)params.get("prefixList");
        for (Map prefixMap : prefixList) {
            AddressTool.addPrefix((int)Integer.valueOf(prefixMap.get("chainId").toString()), (String)String.valueOf(prefixMap.get("addressPrefix")));
            LoggerUtil.LOG.debug("chainId={},prefix={}", new Object[]{prefixMap.get("chainId"), prefixMap.get("addressPrefix")});
        }
        return this.success();
    }
}

