/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.service.AccountKeyStoreService;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.HashMap;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class AliasCmd
extends BaseCmd {
    @Autowired
    private AccountService accountService;
    @Autowired
    private AliasService aliasService;
    @Autowired
    private AccountKeyStoreService keyStoreService;
    @Autowired
    private ChainManager chainManager;

    @CmdAnnotation(cmd="ac_setAlias", version=1.0, description="Set alias/Set the alias of account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address"), @Parameter(parameterName="password", parameterType="String", parameterDes="Account password"), @Parameter(parameterName="alias", parameterType="String", parameterDes="alias")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="txHash", description="Set up alias transactionshash")}))
    public Response setAlias(Map params) {
        Chain chain = null;
        String txHash = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        Object passwordObj = params == null ? null : params.get("password");
        Object aliasObj = params == null ? null : params.get("alias");
        try {
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            String password = passwordObj;
            String alias = aliasObj;
            Transaction transaction = this.aliasService.setAlias(chain, address, password, alias);
            if (transaction != null && transaction.getHash() != null) {
                txHash = transaction.getHash().toHex();
            }
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("txHash", txHash);
        return this.success(result);
    }

    @CmdAnnotation(cmd="ac_getAliasByAddress", version=1.0, description="Retrieve aliases based on address/get the alias by address")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Account address")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="alias", description="alias")}))
    public Response getAliasByAddress(Map params) {
        String alias;
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        try {
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            alias = this.aliasService.getAliasByAddress(chain.getChainId(), address);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("alias", alias);
        return this.success(result);
    }

    @CmdAnnotation(cmd="ac_isAliasUsable", version=1.0, description="Check if aliases are available/check whether the account is usable")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="alias", parameterType="String", parameterDes="alias")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Can aliases be used")}))
    public Response isAliasUsable(Map params) {
        boolean isAliasUsable = false;
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object aliasObj = params == null ? null : params.get("alias");
        try {
            if (params == null || chainIdObj == null || aliasObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String alias = aliasObj;
            isAliasUsable = this.aliasService.isAliasUsable(chain.getChainId(), alias);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        result.put("value", isAliasUsable);
        return this.success(result);
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

