/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.rpc.cmd;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.Account;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.dto.MultiSignTransactionResultDTO;
import io.nuls.account.service.AccountService;
import io.nuls.account.service.AliasService;
import io.nuls.account.service.MultiSignAccountService;
import io.nuls.account.service.TransactionService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.RPCUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.data.MultiSigAccount;
import io.nuls.base.data.Transaction;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.crypto.HexUtil;
import io.nuls.core.exception.NulsException;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.model.FormatValidUtils;
import io.nuls.core.model.StringUtils;
import io.nuls.core.rpc.cmd.BaseCmd;
import io.nuls.core.rpc.model.CmdAnnotation;
import io.nuls.core.rpc.model.Key;
import io.nuls.core.rpc.model.ModuleE;
import io.nuls.core.rpc.model.NulsCoresCmd;
import io.nuls.core.rpc.model.Parameter;
import io.nuls.core.rpc.model.Parameters;
import io.nuls.core.rpc.model.ResponseData;
import io.nuls.core.rpc.model.TypeDescriptor;
import io.nuls.core.rpc.model.message.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
@NulsCoresCmd(module=ModuleE.AC)
public class MultiSignAccountCmd
extends BaseCmd {
    @Autowired
    private MultiSignAccountService multiSignAccountService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AliasService aliasService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ChainManager chainManager;

    @CmdAnnotation(cmd="ac_createMultiSignAccount", version=1.0, description="Create a multi signature account/create a multi sign account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="pubKeys", requestType=@TypeDescriptor(value=List.class, collectionElement=String.class), parameterDes="Public key set(Public key of any ordinary address or ordinary account address existing in the current node)"), @Parameter(parameterName="minSigns", requestType=@TypeDescriptor(value=int.class), parameterDes="Minimum number of signatures")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="address", description="Multiple account addresses signed")}))
    public Response createMultiSignAccount(Map params) {
        Chain chain = null;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        try {
            Object minSignsObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object pubKeysObj = params == null ? null : params.get("pubKeys");
            Object v0 = minSignsObj = params == null ? null : params.get("minSigns");
            if (params == null || chainIdObj == null || pubKeysObj == null || minSignsObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            int chainId = chain.getChainId();
            int minSigns = minSignsObj;
            List pubKeysList = pubKeysObj;
            if (pubKeysList.size() == 0 || minSigns == 0) {
                throw new NulsException(AccountErrorCode.PARAMETER_ERROR);
            }
            if (minSigns == 0) {
                minSigns = pubKeysList.size();
            }
            if (pubKeysList.size() < minSigns) {
                return this.failed(AccountErrorCode.SIGN_COUNT_TOO_LARGE);
            }
            MultiSigAccount multiSigAccount = this.multiSignAccountService.createMultiSigAccount(chain, pubKeysList, minSigns);
            if (multiSigAccount == null) {
                throw new NulsRuntimeException(AccountErrorCode.FAILED);
            }
            ArrayList<String> pubKeys = new ArrayList<String>();
            for (byte[] pubkey : multiSigAccount.getPubKeyList()) {
                pubKeys.add(HexUtil.encode((byte[])pubkey));
            }
            map.put("address", multiSigAccount.getAddress().getBase58());
            map.put("pubKeys", pubKeys);
            map.put("minSign", multiSigAccount.getM());
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_removeMultiSignAccount", version=1.0, description="Remove multiple signed accounts/remove the multi sign account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Multiple account addresses signed")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=boolean.class, description="Was removal successful")}))
    public Response removeMultiSignAccount(Map params) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
        Chain chain = null;
        try {
            Object addressObj;
            Object chainIdObj = params == null ? null : params.get("chainId");
            Object v0 = addressObj = params == null ? null : params.get("address");
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            boolean result = this.multiSignAccountService.removeMultiSigAccount(chain.getChainId(), address);
            map.put("value", result);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return this.success(map);
    }

    @CmdAnnotation(cmd="ac_setMultiSignAlias", version=1.0, description="Set multiple account aliases/set the alias of multi sign account")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Multiple account addresses signed"), @Parameter(parameterName="alias", parameterType="String", parameterDes="alias"), @Parameter(parameterName="signAddress", parameterType="String", canNull=true, parameterDes="First signature account address(If left blank, only create transactions without signing)"), @Parameter(parameterName="signPassword", parameterType="String", canNull=true, parameterDes="First signature account password(If left blank, only create transactions without signing)")})
    @ResponseData(name="Return value", description="Return aMap,Including threekey", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="tx", description="Complete transaction serialization string,If the transaction does not reach the minimum number of signatures, you can continue to sign"), @Key(name="txHash", description="transactionhash"), @Key(name="completed", valueType=boolean.class, description="true:Transaction completed(Broadcasted),false:Transaction not completed,Not reaching the minimum number of signatures")}))
    public Object setMultiAlias(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        Object aliasObj = params == null ? null : params.get("alias");
        Object signAddressObj = params == null ? null : params.get("signAddress");
        Object passwordObj = params == null ? null : params.get("signPassword");
        try {
            if (params == null || chainIdObj == null || addressObj == null || aliasObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            int chainId = chain.getChainId();
            String address = addressObj;
            String signPassword = passwordObj;
            String alias = aliasObj;
            String signAddress = signAddressObj;
            if (null != signAddress && !AddressTool.validAddress((int)chainId, (String)signAddress)) {
                throw new NulsRuntimeException(AccountErrorCode.ADDRESS_ERROR);
            }
            if (!AddressTool.validAddress((int)chainId, (String)address) || !AddressTool.isMultiSignAddress((String)address)) {
                throw new NulsRuntimeException(AccountErrorCode.IS_NOT_MULTI_SIGNATURE_ADDRESS);
            }
            if (StringUtils.isBlank((String)alias)) {
                throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
            }
            if (!FormatValidUtils.validAlias((String)alias)) {
                throw new NulsRuntimeException(AccountErrorCode.ALIAS_FORMAT_WRONG);
            }
            if (!this.aliasService.isAliasUsable(chainId, alias)) {
                throw new NulsRuntimeException(AccountErrorCode.ALIAS_EXIST);
            }
            MultiSignTransactionResultDTO multiSignTransactionResultDto = this.transactionService.setMultiSignAccountAlias(chain, address, alias, signAddress, signPassword);
            boolean result = false;
            if (multiSignTransactionResultDto.isBroadcasted()) {
                result = true;
            }
            Transaction tx = multiSignTransactionResultDto.getTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("completed", result);
            map.put("txHash", tx.getHash().toHex());
            map.put("tx", RPCUtil.encode((byte[])tx.serialize()));
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_getMultiSignAccount", version=1.0, description="Obtain the complete multi signature account based on the address of the multi signature account/Search for multi-signature account by address")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Multiple account addresses signed")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", description="Serializing data strings for multiple account signatures")}))
    public Object getMultiSignAccount(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        try {
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String address = addressObj;
            if (!AddressTool.validAddress((int)chain.getChainId(), (String)address) || !AddressTool.isMultiSignAddress((String)address)) {
                throw new NulsRuntimeException(AccountErrorCode.IS_NOT_MULTI_SIGNATURE_ADDRESS);
            }
            MultiSigAccount multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(address);
            String data = null == multiSigAccount ? null : RPCUtil.encode((byte[])multiSigAccount.serialize());
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("value", data);
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    @CmdAnnotation(cmd="ac_isMultiSignAccountBuilder", version=1.0, description="Verify if one of the creators of the multi signed account/Whether it is multiSign account Builder")
    @Parameters(value={@Parameter(parameterName="chainId", requestType=@TypeDescriptor(value=int.class), parameterDes="chainid"), @Parameter(parameterName="address", parameterType="String", parameterDes="Multiple account addresses signed"), @Parameter(parameterName="pubKey", parameterType="String", parameterDes="Creator public key or address that already exists on the current node")})
    @ResponseData(name="Return value", description="Return aMap", responseType=@TypeDescriptor(value=Map.class, mapKeys={@Key(name="value", valueType=Boolean.class, description="Is it one of the creators who signed multiple accounts")}))
    public Object isMultiSignAccountBuilder(Map params) {
        Chain chain = null;
        Object chainIdObj = params == null ? null : params.get("chainId");
        Object addressObj = params == null ? null : params.get("address");
        Object pubkeyObj = params == null ? null : params.get("pubKey");
        try {
            if (params == null || chainIdObj == null || addressObj == null) {
                throw new NulsRuntimeException(AccountErrorCode.NULL_PARAMETER);
            }
            chain = this.chainManager.getChain((Integer)chainIdObj);
            if (null == chain) {
                throw new NulsRuntimeException(AccountErrorCode.CHAIN_NOT_EXIST);
            }
            String pubkey = pubkeyObj;
            byte[] pubkeyByte = null;
            if (AddressTool.validAddress((int)chain.getChainId(), (String)pubkey) && AddressTool.validNormalAddress((byte[])AddressTool.getAddress((String)pubkey), (int)chain.getChainId())) {
                Account account = this.accountService.getAccount(chain.getChainId(), pubkey);
                if (null == account) {
                    throw new NulsException(AccountErrorCode.ACCOUNT_NOT_EXIST);
                }
                pubkeyByte = account.getPubKey();
            } else {
                pubkeyByte = HexUtil.decode((String)pubkey);
            }
            String address = addressObj;
            if (!AddressTool.validAddress((int)chain.getChainId(), (String)address) || !AddressTool.isMultiSignAddress((String)address)) {
                throw new NulsRuntimeException(AccountErrorCode.IS_NOT_MULTI_SIGNATURE_ADDRESS);
            }
            MultiSigAccount multiSigAccount = this.multiSignAccountService.getMultiSigAccountByAddress(address);
            if (null == multiSigAccount) {
                throw new NulsException(AccountErrorCode.MULTISIGN_ACCOUNT_NOT_EXIST);
            }
            boolean rs = false;
            for (byte[] pubk : multiSigAccount.getPubKeyList()) {
                if (!Arrays.equals(pubk, pubkeyByte)) continue;
                rs = true;
                break;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>(2);
            map.put("value", rs);
            return this.success(map);
        }
        catch (NulsRuntimeException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            return this.failed(e.getErrorCode());
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            return this.failed(AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

