/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.storage.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.bo.tx.AccountBlockInfo;
import io.nuls.account.model.dto.AccountBlockDTO;
import io.nuls.account.model.po.AccountBlockExtendPO;
import io.nuls.account.model.po.AccountBlockPO;
import io.nuls.account.storage.AccountBlockStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.basic.AddressTool;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class AccountBlockStorageServiceImpl
implements AccountBlockStorageService,
InitializingBean {
    public void afterPropertiesSet() {
    }

    private Set<Integer> intArray2set(int[] _array) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int a : _array) {
            result.add(a);
        }
        return result;
    }

    private int[] set2intArray(Set<Integer> set) {
        int[] result = new int[set.size()];
        int i = 0;
        for (Integer s : set) {
            result[i++] = s;
        }
        return result;
    }

    @Override
    public boolean operateAccountList(List<AccountBlockDTO> accountList) throws Exception {
        if (null == accountList || accountList.size() == 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        ArrayList<AccountBlockPO> poList = new ArrayList<AccountBlockPO>();
        for (AccountBlockDTO dto : accountList) {
            HashSet<String> contractSet;
            String[] _contracts;
            Set<Object> typeSet;
            int[] _types;
            byte[] address = dto.getAddress();
            AccountBlockInfo info = dto.getInfo();
            if (info == null) {
                poList.add(new AccountBlockPO(address));
                continue;
            }
            AccountBlockPO po = this.getAccount(address);
            if (po == null) {
                poList.add(new AccountBlockPO(address, info));
                continue;
            }
            if (po.getExtend() == null) {
                po.setExtend(new AccountBlockExtendPO(address, info).serialize());
                poList.add(po);
                continue;
            }
            AccountBlockExtendPO extendPO = new AccountBlockExtendPO();
            extendPO.parse(po.getExtend(), 0);
            int[] types = extendPO.getTypes();
            String[] contracts = extendPO.getContracts();
            int operationType = info.getOperationType();
            if (operationType == 1) {
                _types = info.getTypes();
                if (_types != null) {
                    typeSet = types == null ? new HashSet() : this.intArray2set(types);
                    typeSet.addAll(this.intArray2set(_types));
                    extendPO.setTypes(this.set2intArray(typeSet));
                }
                if ((_contracts = info.getContracts()) != null) {
                    contractSet = contracts == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(contracts));
                    contractSet.addAll(Arrays.asList(_contracts));
                    extendPO.setContracts(contractSet.toArray(new String[contractSet.size()]));
                }
                po.setExtend(extendPO.serialize());
                poList.add(po);
                continue;
            }
            if (operationType != 2) continue;
            _types = info.getTypes();
            if (_types != null) {
                typeSet = types == null ? new HashSet() : this.intArray2set(types);
                typeSet.removeAll(this.intArray2set(_types));
                extendPO.setTypes(this.set2intArray(typeSet));
            }
            if ((_contracts = info.getContracts()) != null) {
                contractSet = contracts == null ? new HashSet() : new HashSet<String>(Arrays.asList(contracts));
                contractSet.removeAll(Arrays.asList(_contracts));
                extendPO.setContracts(contractSet.toArray(new String[contractSet.size()]));
            }
            po.setExtend(extendPO.serialize());
            poList.add(po);
        }
        return this.saveAccountList(poList);
    }

    @Override
    public boolean cancelOperateAccountList(List<AccountBlockDTO> accountList) throws Exception {
        if (null == accountList || accountList.size() == 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        ArrayList<byte[]> accountRemoveList = new ArrayList<byte[]>();
        ArrayList<AccountBlockPO> poList = new ArrayList<AccountBlockPO>();
        for (AccountBlockDTO dto : accountList) {
            HashSet<String> contractSet;
            String[] _contracts;
            Set<Object> typeSet;
            int[] _types;
            byte[] address = dto.getAddress();
            AccountBlockInfo info = dto.getInfo();
            if (info == null) {
                accountRemoveList.add(address);
                continue;
            }
            AccountBlockPO po = this.getAccount(address);
            if (po == null) continue;
            AccountBlockExtendPO extendPO = new AccountBlockExtendPO();
            extendPO.parse(po.getExtend(), 0);
            int[] types = extendPO.getTypes();
            String[] contracts = extendPO.getContracts();
            int operationType = info.getOperationType();
            if (operationType == 1) {
                _types = info.getTypes();
                if (_types != null) {
                    typeSet = types == null ? new HashSet() : this.intArray2set(types);
                    typeSet.removeAll(this.intArray2set(_types));
                    extendPO.setTypes(this.set2intArray(typeSet));
                }
                if ((_contracts = info.getContracts()) != null) {
                    contractSet = contracts == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(contracts));
                    contractSet.removeAll(Arrays.asList(_contracts));
                    extendPO.setContracts(contractSet.toArray(new String[contractSet.size()]));
                }
                po.setExtend(extendPO.serialize());
                poList.add(po);
                continue;
            }
            if (operationType != 2) continue;
            _types = info.getTypes();
            if (_types != null) {
                typeSet = types == null ? new HashSet() : this.intArray2set(types);
                typeSet.addAll(this.intArray2set(_types));
                extendPO.setTypes(this.set2intArray(typeSet));
            }
            if ((_contracts = info.getContracts()) != null) {
                contractSet = contracts == null ? new HashSet() : new HashSet<String>(Arrays.asList(contracts));
                contractSet.addAll(Arrays.asList(_contracts));
                extendPO.setContracts(contractSet.toArray(new String[contractSet.size()]));
            }
            po.setExtend(extendPO.serialize());
            poList.add(po);
        }
        if (!accountRemoveList.isEmpty()) {
            RocksDBService.deleteKeys((String)"account_block", accountRemoveList);
        }
        return this.saveAccountList(poList);
    }

    @Override
    public boolean saveAccountList(List<AccountBlockPO> accountPOList) {
        if (null == accountPOList || accountPOList.size() == 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        HashMap<byte[], byte[]> accountPoMap = new HashMap<byte[], byte[]>();
        try {
            for (AccountBlockPO po : accountPOList) {
                accountPoMap.put(po.getAddress(), po.serialize());
            }
            return RocksDBService.batchPut((String)"account_block", accountPoMap);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public boolean removeAccountList(List<String> accountList) {
        if (null == accountList || accountList.isEmpty()) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        try {
            List addressBytesList = accountList.stream().map(a -> AddressTool.getAddress((String)a)).collect(Collectors.toList());
            return RocksDBService.deleteKeys((String)"account_block", addressBytesList);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_DELETE_ERROR);
        }
    }

    @Override
    public List<AccountBlockPO> getAccountList() {
        ArrayList<AccountBlockPO> accountPOList = new ArrayList<AccountBlockPO>();
        try {
            List list = RocksDBService.valueList((String)"account_block");
            if (list != null) {
                for (byte[] value : list) {
                    AccountBlockPO accountPo = new AccountBlockPO();
                    accountPo.parse(value, 0);
                    accountPOList.add(accountPo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPOList;
    }

    @Override
    public AccountBlockPO getAccount(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account_block", (byte[])address);
        if (null == accountBytes) {
            return null;
        }
        AccountBlockPO accountPo = new AccountBlockPO();
        try {
            accountPo.parse(accountBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPo;
    }

    @Override
    public byte[] getAccountBytes(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account_block", (byte[])address);
        if (null == accountBytes) {
            return null;
        }
        return accountBytes;
    }

    @Override
    public boolean existAccount(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account_block", (byte[])address);
        return null != accountBytes;
    }
}

