/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.storage.impl;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.model.po.AccountPO;
import io.nuls.account.storage.AccountStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.base.data.Address;
import io.nuls.core.basic.InitializingBean;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsRuntimeException;
import io.nuls.core.rockdb.service.RocksDBService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Component
public class AccountStorageServiceImpl
implements AccountStorageService,
InitializingBean {
    public void afterPropertiesSet() {
    }

    @Override
    public boolean saveAccountList(List<AccountPO> accountPOList) {
        if (null == accountPOList || accountPOList.size() == 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        HashMap<byte[], byte[]> accountPoMap = new HashMap<byte[], byte[]>();
        try {
            for (AccountPO po : accountPOList) {
                accountPoMap.put(po.getAddressObj().getAddressBytes(), po.serialize());
            }
            return RocksDBService.batchPut((String)"account", accountPoMap);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public boolean saveAccount(AccountPO account) {
        try {
            return RocksDBService.put((String)"account", (byte[])account.getAddressObj().getAddressBytes(), (byte[])account.serialize());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_BATCH_ERROR);
        }
    }

    @Override
    public boolean removeAccount(Address address) {
        if (null == address || address.getAddressBytes() == null || address.getAddressBytes().length <= 0) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        try {
            return RocksDBService.delete((String)"account", (byte[])address.getAddressBytes());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_SAVE_ERROR);
        }
    }

    @Override
    public List<AccountPO> getAccountList() {
        ArrayList<AccountPO> accountPOList = new ArrayList<AccountPO>();
        try {
            List list = RocksDBService.valueList((String)"account");
            if (list != null) {
                for (byte[] value : list) {
                    AccountPO accountPo = new AccountPO();
                    accountPo.parse(value, 0);
                    accountPOList.add(accountPo);
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPOList;
    }

    @Override
    public AccountPO getAccount(byte[] address) {
        byte[] accountBytes = RocksDBService.get((String)"account", (byte[])address);
        if (null == accountBytes) {
            return null;
        }
        AccountPO accountPo = new AccountPO();
        try {
            accountPo.parse(accountBytes, 0);
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_QUERY_ERROR);
        }
        return accountPo;
    }

    @Override
    public boolean updateAccount(AccountPO po) {
        AccountPO account;
        if (null == po) {
            throw new NulsRuntimeException(AccountErrorCode.PARAMETER_ERROR);
        }
        if (null == po.getAddressObj()) {
            po.setAddressObj(new Address(po.getAddress()));
        }
        if (null == (account = this.getAccount(po.getAddressObj().getAddressBytes()))) {
            throw new NulsRuntimeException(AccountErrorCode.ACCOUNT_NOT_EXIST);
        }
        try {
            return RocksDBService.put((String)"account", (byte[])po.getAddressObj().getAddressBytes(), (byte[])po.serialize());
        }
        catch (Exception e) {
            LoggerUtil.LOG.error(e.getMessage());
            throw new NulsRuntimeException(AccountErrorCode.DB_UPDATE_ERROR);
        }
    }
}

