/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.tx.v11;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.helper.AccountBlockHelper;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.txdata.AccountBlockData;
import io.nuls.account.model.po.AccountBlockPO;
import io.nuls.account.service.AliasService;
import io.nuls.account.storage.AccountBlockStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component(value="AccountUnlockProcessorV11")
public class AccountUnlockProcessorV11
implements TransactionProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AliasService aliasService;
    @Autowired
    private AccountBlockHelper accountBlockHelper;
    @Autowired
    private AccountBlockStorageService accountBlockStorageService;

    public int getType() {
        return 64;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        HashMap<String, Object> result = null;
        Chain chain = null;
        try {
            chain = this.chainManager.getChain(chainId);
            result = new HashMap<String, Object>(4);
            String errorCode = null;
            if (chain == null) {
                errorCode = AccountErrorCode.CHAIN_NOT_EXIST.getCode();
                chain.getLogger().error("chain is not exist, -chainId:{}", new Object[]{chainId});
                result.put("txList", txs);
                result.put("errorCode", errorCode);
                return result;
            }
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (Transaction tx : txs) {
                try {
                    Result rs = this.accountBlockHelper.blockAccountTxValidate(chain, tx);
                    if (!rs.isFailed()) continue;
                    errorCode = rs.getErrorCode().getCode();
                    txList.add(tx);
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                    errorCode = e instanceof NulsException ? ((NulsException)((Object)e)).getErrorCode().getCode() : AccountErrorCode.DATA_ERROR.getCode();
                    txList.add(tx);
                }
            }
            result.put("txList", txList);
            result.put("errorCode", errorCode);
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result.put("txList", txs);
            result.put("errorCode", AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> commitSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            AccountBlockData data = new AccountBlockData();
            try {
                data.parse(new NulsByteBuffer(tx.getTxData()));
                String[] addresses = data.getAddresses();
                result = this.accountBlockStorageService.removeAccountList(Arrays.asList(addresses));
            }
            catch (NulsException e) {
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("ac_commitTx un_block_account tx commit error");
                break;
            }
            commitSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean rollback = true;
                for (Transaction tx : commitSucTxList) {
                    AccountBlockData data = new AccountBlockData();
                    data.parse(new NulsByteBuffer(tx.getTxData()));
                    String[] addresses = data.getAddresses();
                    List<AccountBlockPO> poList = Arrays.asList(addresses).stream().map(a -> new AccountBlockPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                    rollback = this.accountBlockStorageService.saveAccountList(poList);
                }
                if (!rollback) {
                    LoggerUtil.LOG.error("ac_commitTx un_block_account tx rollback error");
                    throw new NulsException(AccountErrorCode.ALIAS_ROLLBACK_ERROR);
                }
            }
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result = false;
        }
        return result;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> rollbackSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            AccountBlockData data = new AccountBlockData();
            try {
                data.parse(new NulsByteBuffer(tx.getTxData()));
                String[] addresses = data.getAddresses();
                List<AccountBlockPO> poList = Arrays.asList(addresses).stream().map(a -> new AccountBlockPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                result = this.accountBlockStorageService.saveAccountList(poList);
            }
            catch (NulsException e) {
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("ac_rollbackTx un_block_account tx rollback error");
                break;
            }
            rollbackSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean commit = true;
                for (Transaction tx : rollbackSucTxList) {
                    AccountBlockData data = new AccountBlockData();
                    data.parse(new NulsByteBuffer(tx.getTxData()));
                    String[] addresses = data.getAddresses();
                    commit = this.accountBlockStorageService.removeAccountList(Arrays.asList(addresses));
                }
                if (!commit) {
                    LoggerUtil.LOG.error("ac_rollbackTx un_block_account tx commit error");
                    throw new NulsException(AccountErrorCode.ALIAS_SAVE_ERROR);
                }
            }
        }
        catch (NulsException e) {
            this.errorLogProcess(chain, (Exception)((Object)e));
            result = false;
        }
        return result;
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

