/*
 * Decompiled with CFR 0.152.
 */
package io.nuls.account.tx.v13;

import io.nuls.account.constant.AccountErrorCode;
import io.nuls.account.helper.AccountContractCallHelper;
import io.nuls.account.model.bo.Chain;
import io.nuls.account.model.bo.tx.txdata.AccountContractCallData;
import io.nuls.account.model.po.AccountContractCallPO;
import io.nuls.account.storage.AccountForTransferOnContractCallStorageService;
import io.nuls.account.util.LoggerUtil;
import io.nuls.account.util.manager.ChainManager;
import io.nuls.base.basic.AddressTool;
import io.nuls.base.basic.NulsByteBuffer;
import io.nuls.base.data.BlockHeader;
import io.nuls.base.data.Transaction;
import io.nuls.base.protocol.TransactionProcessor;
import io.nuls.core.basic.Result;
import io.nuls.core.core.annotation.Autowired;
import io.nuls.core.core.annotation.Component;
import io.nuls.core.exception.NulsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component(value="AccountForTransferOnContractCallProcessorV13")
public class AccountForTransferOnContractCallProcessorV13
implements TransactionProcessor {
    @Autowired
    private ChainManager chainManager;
    @Autowired
    private AccountContractCallHelper accountContractCallHelper;
    @Autowired
    private AccountForTransferOnContractCallStorageService accountForTransferOnContractCallStorageService;

    public int getType() {
        return 65;
    }

    public Map<String, Object> validate(int chainId, List<Transaction> txs, Map<Integer, List<Transaction>> txMap, BlockHeader blockHeader) {
        HashMap<String, Object> result = null;
        Chain chain = null;
        try {
            chain = this.chainManager.getChain(chainId);
            result = new HashMap<String, Object>(4);
            String errorCode = null;
            if (chain == null) {
                errorCode = AccountErrorCode.CHAIN_NOT_EXIST.getCode();
                chain.getLogger().error("chain is not exist, -chainId:{}", new Object[]{chainId});
                result.put("txList", txs);
                result.put("errorCode", errorCode);
                return result;
            }
            ArrayList<Transaction> txList = new ArrayList<Transaction>();
            for (Transaction tx : txs) {
                try {
                    Result rs = this.accountContractCallHelper.validate(chain, tx);
                    if (!rs.isFailed()) continue;
                    errorCode = rs.getErrorCode().getCode();
                    txList.add(tx);
                }
                catch (Exception e) {
                    chain.getLogger().error(e);
                    errorCode = e instanceof NulsException ? ((NulsException)((Object)e)).getErrorCode().getCode() : AccountErrorCode.DATA_ERROR.getCode();
                    txList.add(tx);
                }
            }
            result.put("txList", txList);
            result.put("errorCode", errorCode);
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result.put("txList", txs);
            result.put("errorCode", AccountErrorCode.SYS_UNKOWN_EXCEPTION);
        }
        return result;
    }

    public boolean commit(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> commitSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            AccountContractCallData data = new AccountContractCallData();
            try {
                List<AccountContractCallPO> list;
                data.parse(new NulsByteBuffer(tx.getTxData()));
                String[] addresses = data.getAddresses();
                int type = data.getType();
                if (type == 1) {
                    list = Arrays.asList(addresses).stream().map(a -> new AccountContractCallPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                    result = this.accountForTransferOnContractCallStorageService.saveAccountList(list);
                } else {
                    list = Arrays.asList(addresses).stream().map(a -> AddressTool.getAddress((String)a)).collect(Collectors.toList());
                    result = this.accountForTransferOnContractCallStorageService.removeAccount(list);
                }
            }
            catch (Exception e) {
                LoggerUtil.LOG.error("AccountForTransferOnContractCall tx commit error", e);
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("AccountForTransferOnContractCall tx commit error");
                break;
            }
            commitSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean rollback = true;
                for (Transaction tx : commitSucTxList) {
                    List<byte[]> list;
                    AccountContractCallData data = new AccountContractCallData();
                    data.parse(new NulsByteBuffer(tx.getTxData()));
                    String[] addresses = data.getAddresses();
                    int type = data.getType();
                    if (type == 1) {
                        list = Arrays.asList(addresses).stream().map(a -> AddressTool.getAddress((String)a)).collect(Collectors.toList());
                        rollback = this.accountForTransferOnContractCallStorageService.removeAccount(list);
                        continue;
                    }
                    list = Arrays.asList(addresses).stream().map(a -> new AccountContractCallPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                    rollback = this.accountForTransferOnContractCallStorageService.saveAccountList(list);
                }
                if (!rollback) {
                    LoggerUtil.LOG.error("AccountForTransferOnContractCall tx rollback error");
                    throw new NulsException(AccountErrorCode.ALIAS_ROLLBACK_ERROR);
                }
            }
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result = false;
        }
        return result;
    }

    public boolean rollback(int chainId, List<Transaction> txs, BlockHeader blockHeader) {
        boolean result = true;
        Chain chain = this.chainManager.getChain(chainId);
        ArrayList<Transaction> rollbackSucTxList = new ArrayList<Transaction>();
        for (Transaction tx : txs) {
            AccountContractCallData data = new AccountContractCallData();
            try {
                List<byte[]> list;
                data.parse(new NulsByteBuffer(tx.getTxData()));
                String[] addresses = data.getAddresses();
                int type = data.getType();
                if (type == 1) {
                    list = Arrays.asList(addresses).stream().map(a -> AddressTool.getAddress((String)a)).collect(Collectors.toList());
                    result = this.accountForTransferOnContractCallStorageService.removeAccount(list);
                } else {
                    list = Arrays.asList(addresses).stream().map(a -> new AccountContractCallPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                    result = this.accountForTransferOnContractCallStorageService.saveAccountList(list);
                }
            }
            catch (Exception e) {
                LoggerUtil.LOG.error("AccountForTransferOnContractCall tx rollback error", e);
                result = false;
            }
            if (!result) {
                LoggerUtil.LOG.warn("AccountForTransferOnContractCall tx rollback error");
                break;
            }
            rollbackSucTxList.add(tx);
        }
        try {
            if (!result) {
                boolean commit = true;
                for (Transaction tx : rollbackSucTxList) {
                    List<AccountContractCallPO> list;
                    AccountContractCallData data = new AccountContractCallData();
                    data.parse(new NulsByteBuffer(tx.getTxData()));
                    String[] addresses = data.getAddresses();
                    int type = data.getType();
                    if (type == 1) {
                        list = Arrays.asList(addresses).stream().map(a -> new AccountContractCallPO(AddressTool.getAddress((String)a))).collect(Collectors.toList());
                        commit = this.accountForTransferOnContractCallStorageService.saveAccountList(list);
                        continue;
                    }
                    list = Arrays.asList(addresses).stream().map(a -> AddressTool.getAddress((String)a)).collect(Collectors.toList());
                    commit = this.accountForTransferOnContractCallStorageService.removeAccount(list);
                }
                if (!commit) {
                    LoggerUtil.LOG.error("AccountForTransferOnContractCall tx commit error");
                    throw new NulsException(AccountErrorCode.ALIAS_SAVE_ERROR);
                }
            }
        }
        catch (Exception e) {
            this.errorLogProcess(chain, e);
            result = false;
        }
        return result;
    }

    private void errorLogProcess(Chain chain, Exception e) {
        if (chain == null) {
            LoggerUtil.LOG.error(e);
        } else {
            chain.getLogger().error(e);
        }
    }
}

